/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import io.scanbot.sdk.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0014J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/ui/view/base/FinderOverlayView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bitmap", "Landroid/graphics/Bitmap;", "overlayColor", "", "strokeColor", "strokeWidth", "", "createWindowFrame", "", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "isInEditMode", "", "onLayout", "changed", "l", "t", "r", "b", "setOverlayColor", "setStrokeColor", "setStrokeWidth", "scanbot-sdk-ui_release"})
public final class FinderOverlayView
extends FrameLayout {
    private Bitmap bitmap;
    private int overlayColor;
    private int strokeColor;
    private float strokeWidth;
    private HashMap _$_findViewCache;

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        if (this.bitmap == null) {
            this.createWindowFrame();
        }
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    private final void createWindowFrame() {
        float strokeOffset = this.strokeWidth / (float)2;
        this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        RectF outerRectangle = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        Paint paint = new Paint(1);
        paint.setColor(this.overlayColor);
        canvas.drawRect(outerRectangle, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        float radius = this.getResources().getDimensionPixelSize(R.dimen.mrz_finder_corner_radius);
        canvas.drawRoundRect(new RectF(strokeOffset, strokeOffset, (float)this.getWidth() - strokeOffset, (float)this.getHeight() - strokeOffset), radius, radius, paint);
        paint = new Paint(1);
        paint.setColor(this.strokeColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(this.strokeWidth);
        canvas.drawRoundRect(new RectF(strokeOffset, strokeOffset, (float)this.getWidth() - strokeOffset, (float)this.getHeight() - strokeOffset), radius, radius, paint);
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.bitmap = null;
    }

    public final void setOverlayColor(int overlayColor) {
        this.overlayColor = overlayColor;
        this.invalidate();
    }

    public final void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    public final void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr2) {
        block8: {
            int n;
            int resId$iv;
            Context $receiver$iv;
            Context context2;
            super(context, attr2);
            this.overlayColor = -1;
            this.strokeColor = -1;
            this.strokeWidth = -1.0f;
            Context context3 = context;
            if (context3 == null) break block8;
            Context it = context2 = context3;
            Context context4 = context;
            int n2 = R.attr.mrz_camera_overlay_color;
            Context context5 = context;
            FinderOverlayView finderOverlayView = this;
            TypedArray values$iv = $receiver$iv.obtainStyledAttributes(new int[]{resId$iv});
            try {
                n = values$iv.getResourceId(0, 0);
            }
            finally {
                values$iv.recycle();
            }
            int n3 = n;
            finderOverlayView.overlayColor = ContextCompat.getColor((Context)context5, (int)n3);
            $receiver$iv = context;
            resId$iv = R.attr.mrz_camera_overlay_stroke_color;
            context5 = context;
            finderOverlayView = this;
            values$iv = $receiver$iv.obtainStyledAttributes(new int[]{resId$iv});
            try {
                n = values$iv.getResourceId(0, 0);
            }
            finally {
                values$iv.recycle();
            }
            n3 = n;
            finderOverlayView.strokeColor = ContextCompat.getColor((Context)context5, (int)n3);
            this.strokeWidth = context.getResources().getDimensionPixelSize(R.dimen.mrz_finder_stoke_width);
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

