/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.FrameLayout;

public class CheckableFrameLayout
extends FrameLayout
implements Checkable {
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private boolean checked = false;

    public CheckableFrameLayout(Context context) {
        super(context);
    }

    public CheckableFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(value=11)
    public CheckableFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.checked) {
            int[] states = super.onCreateDrawableState(extraSpace + 1);
            CheckableFrameLayout.mergeDrawableStates((int[])states, (int[])STATE_CHECKED);
            return states;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.setAllChildViewsChecked((ViewGroup)this, checked);
        this.destroyDrawingCache();
        this.refreshDrawableState();
        this.invalidate();
    }

    private void setAllChildViewsChecked(ViewGroup baseView, boolean checked) {
        for (int i = 0; i < baseView.getChildCount(); ++i) {
            View child = baseView.getChildAt(i);
            if (child instanceof Checkable) {
                ((Checkable)child).setChecked(checked);
            }
            if (!(child instanceof ViewGroup)) continue;
            this.setAllChildViewsChecked((ViewGroup)child, checked);
        }
    }

    public void toggle() {
        this.setChecked(!this.checked);
    }
}

