/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.camera;

import android.graphics.PointF;
import android.os.SystemClock;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.AutoSnappingController;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.entity.workflow.WorkflowStep;
import io.scanbot.sdk.ui.view.workflow.camera.WorkflowFrameHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowAutoSnappingController;", "Lio/scanbot/sdk/camera/AutoSnappingController;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "workflowFrameHandler", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "(Lio/scanbot/sdk/ui/camera/IScanbotCameraView;Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;)V", "Companion", "DetectionHandler", "rtu-ui-bundle_release"})
public final class WorkflowAutoSnappingController
extends AutoSnappingController {
    public static final Companion Companion = new Companion(null);

    public WorkflowAutoSnappingController(@NotNull IScanbotCameraView cameraView, @NotNull WorkflowFrameHandler workflowFrameHandler) {
        Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
        Intrinsics.checkParameterIsNotNull((Object)workflowFrameHandler, (String)"workflowFrameHandler");
        super(cameraView, (FrameHandler)workflowFrameHandler);
        workflowFrameHandler.addResultHandler(new DetectionHandler());
    }

    public static final /* synthetic */ void access$setCapturing$p(WorkflowAutoSnappingController $this, AtomicBoolean atomicBoolean) {
        $this.capturing = atomicBoolean;
    }

    public static final /* synthetic */ void access$setIgnoreBadAspectRatio$p(WorkflowAutoSnappingController $this, boolean bl) {
        $this.ignoreBadAspectRatio = bl;
    }

    public static final /* synthetic */ void access$onDetectionOK(WorkflowAutoSnappingController $this, List polygon) {
        $this.onDetectionOK(polygon);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowAutoSnappingController$DetectionHandler;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$ResultHandler;", "(Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowAutoSnappingController;)V", "checkDetectionResult", "", "detectionResult", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "handle", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler$DetectedFrameData;", "Lio/scanbot/sdk/SdkLicenseError;", "handleSuccess", "detectedFrameData", "postDetectionOK", "", "polygon", "", "Landroid/graphics/PointF;", "rtu-ui-bundle_release"})
    private final class DetectionHandler
    implements WorkflowFrameHandler.ResultHandler {
        public boolean handle(@NotNull FrameHandlerResult<WorkflowFrameHandler.DetectedFrameData, SdkLicenseError> result) {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            FrameHandlerResult<WorkflowFrameHandler.DetectedFrameData, SdkLicenseError> frameHandlerResult = result;
            if (frameHandlerResult instanceof FrameHandlerResult.Success) {
                WorkflowAutoSnappingController.this.logger.logMethod();
                WorkflowFrameHandler.DetectedFrameData detectedFrameData = (WorkflowFrameHandler.DetectedFrameData)((FrameHandlerResult.Success)result).getValue();
                return this.handleSuccess(detectedFrameData);
            }
            return false;
        }

        private final boolean handleSuccess(WorkflowFrameHandler.DetectedFrameData detectedFrameData) {
            DetectionResult detectionResult = detectedFrameData.getDetectionResult();
            if (WorkflowAutoSnappingController.this.capturing.get()) {
                boolean readyToCapture;
                if (detectedFrameData.getWorkflowStepResult() == null) {
                    return false;
                }
                WorkflowStep currentStep = detectedFrameData.getWorkflowStepResult().getStep();
                boolean bl = readyToCapture = currentStep.getWantsCapturedPage() && this.checkDetectionResult(detectionResult);
                if (!readyToCapture) {
                    return false;
                }
                if (SystemClock.elapsedRealtime() - WorkflowAutoSnappingController.this.lastCapture > WorkflowAutoSnappingController.this.captureInterval.get()) {
                    if (WorkflowAutoSnappingController.this.lastCapture != 0L) {
                        this.postDetectionOK(detectedFrameData.getPolygon());
                    }
                    WorkflowAutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                }
            }
            return false;
        }

        private final boolean checkDetectionResult(DetectionResult detectionResult) {
            return detectionResult == DetectionResult.OK || WorkflowAutoSnappingController.this.ignoreBadAspectRatio && detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO;
        }

        private final void postDetectionOK(List<? extends PointF> polygon) {
            WorkflowAutoSnappingController.this.mainThreadHandler.post(new Runnable(this, polygon){
                final /* synthetic */ DetectionHandler this$0;
                final /* synthetic */ List $polygon;

                public final void run() {
                    WorkflowAutoSnappingController.access$onDetectionOK(this.this$0.WorkflowAutoSnappingController.this, this.$polygon);
                }
                {
                    this.this$0 = detectionHandler;
                    this.$polygon = list;
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowAutoSnappingController$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowAutoSnappingController;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "workflowFrameHandler", "Lio/scanbot/sdk/ui/view/workflow/camera/WorkflowFrameHandler;", "rtu-ui-bundle_release"})
    public static final class Companion {
        @NotNull
        public final WorkflowAutoSnappingController attach(@NotNull IScanbotCameraView cameraView, @NotNull WorkflowFrameHandler workflowFrameHandler) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)workflowFrameHandler, (String)"workflowFrameHandler");
            return new WorkflowAutoSnappingController(cameraView, workflowFrameHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

