/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.scanbot.sdk.idcardscanner.IdCardScanner;
import io.scanbot.sdk.persistance.IdCardFileStorage;
import io.scanbot.sdk.ui.di.components.IdCardCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.IdCardModule;
import io.scanbot.sdk.ui.di.modules.IdCardModule_ProvideIdCardScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.idcard.BaseIdCardCameraFragment;
import io.scanbot.sdk.ui.view.idcard.BaseIdCardCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.idcard.IdCardCameraFragment;
import io.scanbot.sdk.ui.view.idcard.IdCardCameraPresenter;
import io.scanbot.sdk.ui.view.idcard.IdCardScanningSession;
import io.scanbot.sdk.ui.view.idcard.interactor.SaveIdCardImagesUseCase;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import javax.inject.Provider;

public final class DaggerIdCardCameraComponent
implements IdCardCameraComponent {
    private SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<IdCardScanningSession> provideIdCardScanningSession$rtu_ui_bundle_releaseProvider;

    private DaggerIdCardCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNull((Object)this.sDKUIComponent.provideContext(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private IdCardCameraPresenter getIdCardCameraPresenter() {
        return new IdCardCameraPresenter(this.getCheckCameraPermissionUseCase(), (Navigator)this.providesNavigatorProvider.get(), (IdCardScanningSession)this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider.get());
    }

    private SaveIdCardImagesUseCase getSaveIdCardImagesUseCase() {
        return new SaveIdCardImagesUseCase((IdCardFileStorage)Preconditions.checkNotNull((Object)this.sDKUIComponent.idCardFileStorage(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private IdCardFieldListPresenter getIdCardFieldListPresenter() {
        return new IdCardFieldListPresenter((Navigator)this.providesNavigatorProvider.get(), (IdCardScanningSession)this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider.get(), this.getSaveIdCardImagesUseCase());
    }

    private void initialize(Builder builder) {
        this.sDKUIComponent = builder.sDKUIComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)builder.navigatorModule));
        this.provideIdCardScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)IdCardModule_ProvideIdCardScanningSession$rtu_ui_bundle_releaseFactory.create(builder.idCardModule));
    }

    @Override
    public void inject(IdCardCameraFragment idCardCameraFragment) {
        this.injectIdCardCameraFragment(idCardCameraFragment);
    }

    private IdCardCameraFragment injectIdCardCameraFragment(IdCardCameraFragment instance) {
        BaseIdCardCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseIdCardCameraFragment)instance, (CheckCameraPermissionUseCase)this.getCheckCameraPermissionUseCase());
        BaseIdCardCameraFragment_MembersInjector.injectIdCardScanner((BaseIdCardCameraFragment)instance, (IdCardScanner)((IdCardScanner)Preconditions.checkNotNull((Object)this.sDKUIComponent.idCardScanner(), (String)"Cannot return null from a non-@Nullable component method")));
        BaseIdCardCameraFragment_MembersInjector.injectIdCardCameraPresenter((BaseIdCardCameraFragment)instance, (IdCardCameraPresenter)this.getIdCardCameraPresenter());
        BaseIdCardCameraFragment_MembersInjector.injectIdCardFieldListPresenter((BaseIdCardCameraFragment)instance, (IdCardFieldListPresenter)this.getIdCardFieldListPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private IdCardModule idCardModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public IdCardCameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.idCardModule == null) {
                throw new IllegalStateException(IdCardModule.class.getCanonicalName() + " must be set");
            }
            if (this.sDKUIComponent == null) {
                throw new IllegalStateException(SDKUIComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerIdCardCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder idCardModule(IdCardModule idCardModule) {
            this.idCardModule = (IdCardModule)Preconditions.checkNotNull((Object)idCardModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }
    }
}

