/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.docprocessing.PageProcessor;
import io.scanbot.sdk.persistence.DraftPagesRepository;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.ui.di.components.CameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.camera.CameraFragment;
import io.scanbot.sdk.ui.view.camera.CameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.camera.CameraPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.FilterDocumentPageUseCase;
import io.scanbot.sdk.ui.view.interactor.FinalizePagesUseCase;
import io.scanbot.sdk.ui.view.interactor.RemoveDraftPageUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerCameraComponent
implements CameraComponent {
    private final SDKUIComponent sDKUIComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerCameraComponent(NavigatorModule navigatorModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.sDKUIComponent = sDKUIComponentParam;
        this.initialize(navigatorModuleParam, sDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase checkCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext()));
    }

    private SaveTakenPictureUseCase saveTakenPictureUseCase() {
        return new SaveTakenPictureUseCase((DraftPagesRepository)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.draftPagesRepository()));
    }

    private FilterDocumentPageUseCase filterDocumentPageUseCase() {
        return new FilterDocumentPageUseCase((PageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageProcessor()));
    }

    private RemoveDraftPageUseCase removeDraftPageUseCase() {
        return new RemoveDraftPageUseCase((Cleaner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideCleaner()));
    }

    private FinalizePagesUseCase finalizePagesUseCase() {
        return new FinalizePagesUseCase((PageStorageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageStorageProcessor()));
    }

    private CameraPresenter cameraPresenter() {
        return new CameraPresenter(this.checkCameraPermissionUseCase(), this.saveTakenPictureUseCase(), this.filterDocumentPageUseCase(), this.removeDraftPageUseCase(), this.finalizePagesUseCase(), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideBackgroundTaskScheduler()), (Scheduler)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideUiScheduler()));
    }

    private void initialize(NavigatorModule navigatorModuleParam, SDKUIComponent sDKUIComponentParam) {
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
    }

    @Override
    public void inject(CameraFragment cameraFragment) {
        this.injectCameraFragment(cameraFragment);
    }

    private CameraFragment injectCameraFragment(CameraFragment instance) {
        CameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.checkCameraPermissionUseCase());
        CameraFragment_MembersInjector.injectCameraPresenter(instance, this.cameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DaggerCameraComponent(this.navigatorModule, this.sDKUIComponent);
        }
    }
}

