/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.workflow.configuration.WorkflowScannerConfigurationParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b=\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\n2\b\b\u0001\u0010\u001e\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020#J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\n2\b\b\u0001\u00101\u001a\u00020\u0014J\u0010\u00102\u001a\u00020\n2\b\b\u0001\u00103\u001a\u00020\u0014J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020#J\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020#J\u0010\u00108\u001a\u00020\n2\b\b\u0001\u00109\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0014J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020#J\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0011J\u0010\u0010@\u001a\u00020\n2\b\b\u0001\u0010A\u001a\u00020\u0014J\u000e\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020\n2\b\b\u0001\u0010F\u001a\u00020\u0014J\u000e\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020#J\u0010\u0010I\u001a\u00020\n2\b\b\u0001\u0010J\u001a\u00020\u0014J\u0010\u0010K\u001a\u00020\n2\b\b\u0001\u0010L\u001a\u00020\u0014J\u0010\u0010M\u001a\u00020\n2\b\b\u0001\u0010N\u001a\u00020\u0014J\u0010\u0010O\u001a\u00020\n2\b\b\u0001\u0010P\u001a\u00020\u0014J\u0010\u0010Q\u001a\u00020\n2\b\b\u0001\u0010R\u001a\u00020\u0014J\u000e\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\u0014J\u000e\u0010U\u001a\u00020\n2\u0006\u0010V\u001a\u00020\u0014J\u0010\u0010W\u001a\u00020\n2\b\b\u0001\u0010X\u001a\u00020\u0014J\u0010\u0010Y\u001a\u00020\n2\b\b\u0001\u0010Z\u001a\u00020\u0014J\u0010\u0010[\u001a\u00020\n2\b\b\u0001\u0010\\\u001a\u00020\u0014J\u0010\u0010]\u001a\u00020\n2\b\b\u0001\u0010^\u001a\u00020\u0014J\u0010\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020#H\u0007J\u000e\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020#J\u000e\u0010c\u001a\u00020\n2\u0006\u0010d\u001a\u00020\u0005J\u000e\u0010e\u001a\u00020\n2\u0006\u0010f\u001a\u00020\u0005J\u000e\u0010g\u001a\u00020\n2\u0006\u0010h\u001a\u00020\u0005J\u000e\u0010i\u001a\u00020\n2\u0006\u0010j\u001a\u00020\u0005J\u000e\u0010k\u001a\u00020\n2\u0006\u0010l\u001a\u00020\u0005J\u000e\u0010m\u001a\u00020\n2\u0006\u0010n\u001a\u00020\u0005J\u000e\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u0005J\u000e\u0010q\u001a\u00020\n2\u0006\u0010r\u001a\u00020\u0005J\u0010\u0010s\u001a\u00020\n2\b\b\u0001\u0010t\u001a\u00020\u0014J\u0010\u0010u\u001a\u00020\n2\b\b\u0001\u0010v\u001a\u00020\u0014J\u0010\u0010w\u001a\u00020\n2\b\b\u0001\u0010x\u001a\u00020\u0014J\u0010\u0010y\u001a\u00020\n2\b\b\u0001\u0010z\u001a\u00020\u0014J\u000e\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020#J\u0010\u0010}\u001a\u00020\n2\b\b\u0001\u0010~\u001a\u00020\u0014J\u0011\u0010\u007f\u001a\u00020\n2\t\b\u0001\u0010\u0080\u0001\u001a\u00020\u0014R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0081\u0001"}, d2={"Lio/scanbot/sdk/ui/view/workflow/configuration/WorkflowScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "setAcceptedAngleScore", "", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "setCleanupOnCancel", "cleanupOnCancel", "", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderBackgroundColor", "finderBackgroundColor", "setFinderLineColor", "finderLineColor", "setFlashButtonHidden", "flashButtonHidden", "setFlashEnabled", "flashEnabled", "setHintBackgroundColor", "hintBackgroundColor", "setHintCornerRadius", "hintCornerRadius", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageScale", "imageScale", "setMessageTextColor", "messageTextColor", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "enabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setSuccessBeepEnabled", "successBeepEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintOffCenter", "textHintOffCenter", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTitleTextColor", "titleTextColor", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "rtu-ui-bundle_release"})
public final class WorkflowScannerConfiguration {
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.FLASH_ENABLED.getKey();
        Boolean bl = flashEnabled;
        map.put(string, bl);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey();
        Long l = delay;
        map.put(string, l);
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey();
        Float f = Float.valueOf(autoSnappingSensitivity);
        map.put(string, f);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey();
        map.put(string, (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey();
        map.put(string, (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CAMERA_MODULE.getKey();
        map.put(string, (Serializable)cameraModule);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey();
        Boolean bl = ignoreBadAspectRatio;
        map.put(string, bl);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey();
        Double d = acceptedAngleScore;
        map.put(string, d);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey();
        Double d = acceptedSizeScore;
        map.put(string, d);
    }

    public final void setImageScale(float imageScale) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.IMAGE_SCALE.getKey();
        float f = Math.max(0.0f, imageScale);
        float f2 = 1.0f;
        Float f3 = Float.valueOf(Math.min(f, f2));
        map.put(string, f3);
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.FINDER_LINE_COLOR.getKey();
        Integer n = finderLineColor;
        map.put(string, n);
    }

    public final void setFinderBackgroundColor(@ColorInt int finderBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.FINDER_BACKGROUND_COLOR.getKey();
        Integer n = finderBackgroundColor;
        map.put(string, n);
    }

    public final void setTitleTextColor(@ColorInt int titleTextColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TITLE_TEXT_COLOR.getKey();
        Integer n = titleTextColor;
        map.put(string, n);
    }

    public final void setMessageTextColor(@ColorInt int messageTextColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.MESSAGE_TEXT_COLOR.getKey();
        Integer n = messageTextColor;
        map.put(string, n);
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_COLOR.getKey();
        Integer n = polygonColor;
        map.put(string, n);
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_COLOR_OK.getKey();
        Integer n = polygonColorOK;
        map.put(string, n);
    }

    public final void setPolygonLineWidth(int polygonLineWidth) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey();
        Integer n = polygonLineWidth;
        map.put(string, n);
    }

    public final void setPolygonCornerRadius(int polygonCornerRadius) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey();
        Integer n = polygonCornerRadius;
        map.put(string, n);
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey();
        Integer n = polygonBackgroundColor;
        map.put(string, n);
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey();
        Boolean bl = drawPolygonShadows;
        map.put(string, bl);
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey();
        Integer n = polygonBackgroundColorOK;
        map.put(string, n);
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey();
        Integer n = polygonAutoSnapProgressColor;
        map.put(string, n);
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey();
        Integer n = polygonProgressLineWidth;
        map.put(string, n);
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey();
        Boolean bl = enabled;
        map.put(string, bl);
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey();
        Integer n = shutterButtonAutoOuterColor;
        map.put(string, n);
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey();
        Integer n = shutterButtonAutoInnerColor;
        map.put(string, n);
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey();
        Integer n = shutterButtonManualOuterColor;
        map.put(string, n);
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey();
        Integer n = shutterButtonManualInnerColor;
        map.put(string, n);
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey();
        Boolean bl = shutterSoundEnabled;
        map.put(string, bl);
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey();
        Integer n = userGuidanceBackgroundColor;
        map.put(string, n);
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey();
        Integer n = userGuidanceTextColor;
        map.put(string, n);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey();
        Integer n = topBarBackgroundColor;
        map.put(string, n);
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey();
        Integer n = topBarButtonsActiveColor;
        map.put(string, n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey();
        Integer n = topBarButtonsInactiveColor;
        map.put(string, n);
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey();
        Integer n = bottomBarBackgroundColor;
        map.put(string, n);
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey();
        Integer n = cameraBackgroundColor;
        map.put(string, n);
    }

    public final void setHintBackgroundColor(@ColorInt int hintBackgroundColor) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.HINT_BACKGROUND_COLOR.getKey();
        Integer n = hintBackgroundColor;
        map.put(string, n);
    }

    public final void setHintCornerRadius(int hintCornerRadius) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.HINT_CORNER_RADIUS.getKey();
        Integer n = hintCornerRadius;
        map.put(string, n);
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey();
        Boolean bl = flashButtonHidden;
        map.put(string, bl);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey();
        map.put(string, (Serializable)((Object)cancelButtonTitle));
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CANCEL_BUTTON_ICON.getKey();
        Integer n = cancelButtonIcon;
        map.put(string, n);
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_OK.getKey();
        map.put(string, (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey();
        map.put(string, (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey();
        map.put(string, (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey();
        map.put(string, (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setSuccessBeepEnabled(boolean successBeepEnabled) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.SUCCESS_BEEP_ENABLED.getKey();
        Boolean bl = successBeepEnabled;
        map.put(string, bl);
    }

    public final void setCleanupOnCancel(boolean cleanupOnCancel) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.CLEANUP_ON_CANCEL.getKey();
        Boolean bl = cleanupOnCancel;
        map.put(string, bl);
    }

    public final void setTextHintOffCenter(@NotNull String textHintOffCenter) {
        Intrinsics.checkNotNullParameter((Object)textHintOffCenter, (String)"textHintOffCenter");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_OFF_CENTER.getKey();
        map.put(string, (Serializable)((Object)textHintOffCenter));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey();
        map.put(string, (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey();
        map.put(string, (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey();
        map.put(string, (Serializable)((Object)textHintTooDark));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey();
        map.put(string, (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey();
        map.put(string, (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Map<String, Serializable> map = this.cameraConfiguration;
        String string = WorkflowScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey();
        Boolean bl = allCaps;
        map.put(string, bl);
    }
}

