/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.workflow.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.workflow.configuration.WorkflowScannerConfigurationParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b=\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\n2\b\b\u0001\u0010\u001e\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020#J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u0010\u00100\u001a\u00020\n2\b\b\u0001\u00101\u001a\u00020\u0014J\u0010\u00102\u001a\u00020\n2\b\b\u0001\u00103\u001a\u00020\u0014J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020#J\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020#J\u0010\u00108\u001a\u00020\n2\b\b\u0001\u00109\u001a\u00020\u0014J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0014J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020#J\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0011J\u0010\u0010@\u001a\u00020\n2\b\b\u0001\u0010A\u001a\u00020\u0014J\u000e\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020\n2\b\b\u0001\u0010F\u001a\u00020\u0014J\u000e\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020#J\u0010\u0010I\u001a\u00020\n2\b\b\u0001\u0010J\u001a\u00020\u0014J\u0010\u0010K\u001a\u00020\n2\b\b\u0001\u0010L\u001a\u00020\u0014J\u0010\u0010M\u001a\u00020\n2\b\b\u0001\u0010N\u001a\u00020\u0014J\u0010\u0010O\u001a\u00020\n2\b\b\u0001\u0010P\u001a\u00020\u0014J\u0010\u0010Q\u001a\u00020\n2\b\b\u0001\u0010R\u001a\u00020\u0014J\u000e\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\u0014J\u000e\u0010U\u001a\u00020\n2\u0006\u0010V\u001a\u00020\u0014J\u0010\u0010W\u001a\u00020\n2\b\b\u0001\u0010X\u001a\u00020\u0014J\u0010\u0010Y\u001a\u00020\n2\b\b\u0001\u0010Z\u001a\u00020\u0014J\u0010\u0010[\u001a\u00020\n2\b\b\u0001\u0010\\\u001a\u00020\u0014J\u0010\u0010]\u001a\u00020\n2\b\b\u0001\u0010^\u001a\u00020\u0014J\u0010\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020#H\u0007J\u000e\u0010a\u001a\u00020\n2\u0006\u0010b\u001a\u00020#J\u000e\u0010c\u001a\u00020\n2\u0006\u0010d\u001a\u00020\u0005J\u000e\u0010e\u001a\u00020\n2\u0006\u0010f\u001a\u00020\u0005J\u000e\u0010g\u001a\u00020\n2\u0006\u0010h\u001a\u00020\u0005J\u000e\u0010i\u001a\u00020\n2\u0006\u0010j\u001a\u00020\u0005J\u000e\u0010k\u001a\u00020\n2\u0006\u0010l\u001a\u00020\u0005J\u000e\u0010m\u001a\u00020\n2\u0006\u0010n\u001a\u00020\u0005J\u000e\u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\u0005J\u000e\u0010q\u001a\u00020\n2\u0006\u0010r\u001a\u00020\u0005J\u0010\u0010s\u001a\u00020\n2\b\b\u0001\u0010t\u001a\u00020\u0014J\u0010\u0010u\u001a\u00020\n2\b\b\u0001\u0010v\u001a\u00020\u0014J\u0010\u0010w\u001a\u00020\n2\b\b\u0001\u0010x\u001a\u00020\u0014J\u0010\u0010y\u001a\u00020\n2\b\b\u0001\u0010z\u001a\u00020\u0014J\u000e\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020#J\u0010\u0010}\u001a\u00020\n2\b\b\u0001\u0010~\u001a\u00020\u0014J\u0011\u0010\u007f\u001a\u00020\n2\t\b\u0001\u0010\u0080\u0001\u001a\u00020\u0014R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0081\u0001"}, d2={"Lio/scanbot/sdk/ui/view/workflow/configuration/WorkflowScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "setAcceptedAngleScore", "", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "setCleanupOnCancel", "cleanupOnCancel", "", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderBackgroundColor", "finderBackgroundColor", "setFinderLineColor", "finderLineColor", "setFlashButtonHidden", "flashButtonHidden", "setFlashEnabled", "flashEnabled", "setHintBackgroundColor", "hintBackgroundColor", "setHintCornerRadius", "hintCornerRadius", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageScale", "imageScale", "setMessageTextColor", "messageTextColor", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "enabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setSuccessBeepEnabled", "successBeepEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintOffCenter", "textHintOffCenter", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTitleTextColor", "titleTextColor", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "rtu-ui-bundle_release"})
public final class WorkflowScannerConfiguration {
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        Float f = Float.valueOf(autoSnappingSensitivity);
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), f);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        Boolean bl = ignoreBadAspectRatio;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), bl);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        Double d = acceptedAngleScore;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), d);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        Double d = acceptedSizeScore;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), d);
    }

    public final void setImageScale(float imageScale) {
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(Math.max(0.0f, imageScale), 1.0f)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Integer n = finderLineColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.FINDER_LINE_COLOR.getKey(), n);
    }

    public final void setFinderBackgroundColor(@ColorInt int finderBackgroundColor) {
        Integer n = finderBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.FINDER_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTitleTextColor(@ColorInt int titleTextColor) {
        Integer n = titleTextColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TITLE_TEXT_COLOR.getKey(), n);
    }

    public final void setMessageTextColor(@ColorInt int messageTextColor) {
        Integer n = messageTextColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.MESSAGE_TEXT_COLOR.getKey(), n);
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        Integer n = polygonColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_COLOR.getKey(), n);
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        Integer n = polygonColorOK;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), n);
    }

    public final void setPolygonLineWidth(int polygonLineWidth) {
        Integer n = polygonLineWidth;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonCornerRadius(int polygonCornerRadius) {
        Integer n = polygonCornerRadius;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), n);
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        Integer n = polygonBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        Boolean bl = drawPolygonShadows;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), bl);
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        Integer n = polygonBackgroundColorOK;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        Integer n = polygonAutoSnapProgressColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        Integer n = polygonProgressLineWidth;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey(), bl);
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        Integer n = shutterButtonAutoOuterColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        Integer n = shutterButtonAutoInnerColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        Integer n = shutterButtonManualOuterColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        Integer n = shutterButtonManualInnerColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), n);
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        Boolean bl = shutterSoundEnabled;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), bl);
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        Integer n = userGuidanceBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        Integer n = userGuidanceTextColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), n);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        Integer n = topBarButtonsActiveColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        Integer n = bottomBarBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        Integer n = cameraBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setHintBackgroundColor(@ColorInt int hintBackgroundColor) {
        Integer n = hintBackgroundColor;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.HINT_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setHintCornerRadius(int hintCornerRadius) {
        Integer n = hintCornerRadius;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.HINT_CORNER_RADIUS.getKey(), n);
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        Boolean bl = flashButtonHidden;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        Integer n = cancelButtonIcon;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CANCEL_BUTTON_ICON.getKey(), n);
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setSuccessBeepEnabled(boolean successBeepEnabled) {
        Boolean bl = successBeepEnabled;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.SUCCESS_BEEP_ENABLED.getKey(), bl);
    }

    public final void setCleanupOnCancel(boolean cleanupOnCancel) {
        Boolean bl = cleanupOnCancel;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.CLEANUP_ON_CANCEL.getKey(), bl);
    }

    public final void setTextHintOffCenter(@NotNull String textHintOffCenter) {
        Intrinsics.checkNotNullParameter((Object)textHintOffCenter, (String)"textHintOffCenter");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_OFF_CENTER.getKey(), (Serializable)((Object)textHintOffCenter));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.cameraConfiguration.put(WorkflowScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }
}

