/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.configuration;

import android.app.Application;
import com.google.gson.Gson;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.configuration.json.JsonFileEncryptionMode;
import io.scanbot.sdk.configuration.json.JsonStorageImageFormat;
import io.scanbot.sdk.configuration.json.ScanbotSdkJsonConfiguration;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.persistence.CameraImageFormat;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.AESEncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonDocumentDetectorMode;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u0006\u001a\u00020\t*\u00020\n\u001a\n\u0010\u0006\u001a\u00020\u000b*\u00020\f\u00a8\u0006\r"}, d2={"fromJson", "Lio/scanbot/sdk/ScanbotSDKInitializer;", "application", "Landroid/app/Application;", "input", "", "toSdk", "Lio/scanbot/sdk/persistence/fileio/AESEncryptedFileIOProcessor$AESEncrypterMode;", "Lio/scanbot/sdk/configuration/json/JsonFileEncryptionMode;", "Lio/scanbot/sdk/persistence/CameraImageFormat;", "Lio/scanbot/sdk/configuration/json/JsonStorageImageFormat;", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "Lio/scanbot/sdk/ui/configuration/json/JsonDocumentDetectorMode;", "rtu-ui-bundle_release"})
public final class ScanbotSdkConfigurationKt {
    @NotNull
    public static final ScanbotSDKInitializer fromJson(@NotNull ScanbotSDKInitializer $this$fromJson, @NotNull Application application, @NotNull String input) {
        ScanbotSDKInitializer scanbotSDKInitializer;
        block10: {
            AESEncryptedFileIOProcessor aESEncryptedFileIOProcessor;
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$fromJson, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            ScanbotSdkJsonConfiguration jsonConfig = (ScanbotSdkJsonConfiguration)gson.fromJson(input, ScanbotSdkJsonConfiguration.class);
            ScanbotSDKInitializer $this$fromJson_u24lambda_u2d9 = scanbotSDKInitializer = new ScanbotSDKInitializer();
            boolean bl = false;
            PageStorageSettings.Builder builder = new PageStorageSettings.Builder();
            JsonStorageImageFormat jsonStorageImageFormat = jsonConfig.getStorageImageFormat();
            if (jsonStorageImageFormat != null) {
                JsonStorageImageFormat it = jsonStorageImageFormat;
                boolean bl2 = false;
                builder.imageFormat(ScanbotSdkConfigurationKt.toSdk(it));
            }
            Integer n = jsonConfig.getStorageImageQuality();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                builder.imageQuality(it);
            }
            $this$fromJson_u24lambda_u2d9.usePageStorageSettings(builder.build());
            Boolean bl4 = jsonConfig.getLoggingEnabled();
            Boolean bl5 = jsonConfig.getEnableNativeLogging();
            $this$fromJson_u24lambda_u2d9.withLogging(bl4 != null ? bl4 : false, bl5 != null ? bl5 : false);
            JsonDocumentDetectorMode jsonDocumentDetectorMode = jsonConfig.getDocumentDetectorMode();
            if (jsonDocumentDetectorMode != null) {
                JsonDocumentDetectorMode it = jsonDocumentDetectorMode;
                boolean bl6 = false;
                $this$fromJson_u24lambda_u2d9.contourDetectorType(ScanbotSdkConfigurationKt.toSdk(it));
            }
            if ((object = jsonConfig) != null && (object = object.getFileEncryptionMode()) != null) {
                Object it = object;
                boolean bl7 = false;
                String string = jsonConfig.getFileEncryptionPassword();
                if (string == null) {
                    string = "";
                }
                aESEncryptedFileIOProcessor = new AESEncryptedFileIOProcessor(string, ScanbotSdkConfigurationKt.toSdk((JsonFileEncryptionMode)((Object)it)));
            } else {
                aESEncryptedFileIOProcessor = null;
            }
            AESEncryptedFileIOProcessor fileIOProcessor = aESEncryptedFileIOProcessor;
            $this$fromJson_u24lambda_u2d9.useFileEncryption(jsonConfig.getFileEncryptionMode() != null, (FileIOProcessor)fileIOProcessor);
            String string = jsonConfig.getStorageBaseDirectory();
            if (string != null) {
                String it = string;
                boolean bl8 = false;
                $this$fromJson_u24lambda_u2d9.sdkFilesDirectory(application, new File(it));
            }
            Boolean bl9 = jsonConfig.getUseCameraX();
            if (bl9 != null) {
                boolean it = bl9;
                boolean bl10 = false;
                $this$fromJson_u24lambda_u2d9.useCameraXRtuUi(it);
            }
            String string2 = jsonConfig.getLicenseKey();
            if (string2 != null) {
                String it = string2;
                boolean bl11 = false;
                $this$fromJson_u24lambda_u2d9.license(application, it);
            }
            Boolean bl12 = jsonConfig.getAllowGpuAcceleration();
            if (bl12 != null) {
                boolean it = bl12;
                boolean bl13 = false;
                $this$fromJson_u24lambda_u2d9.allowGpuAcceleration(it);
            }
            Boolean bl14 = jsonConfig.getAllowXnnpackAcceleration();
            if (bl14 == null) break block10;
            boolean it = bl14;
            boolean bl15 = false;
            $this$fromJson_u24lambda_u2d9.allowXnnpackAcceleration(it);
        }
        return scanbotSDKInitializer;
    }

    @NotNull
    public static final CameraImageFormat toSdk(@NotNull JsonStorageImageFormat $this$toSdk) {
        CameraImageFormat cameraImageFormat;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSdk), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toSdk.ordinal()]) {
            case 1: {
                cameraImageFormat = CameraImageFormat.JPG;
                break;
            }
            case 2: {
                cameraImageFormat = CameraImageFormat.PNG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cameraImageFormat;
    }

    @NotNull
    public static final ContourDetector.Type toSdk(@NotNull JsonDocumentDetectorMode $this$toSdk) {
        ContourDetector.Type type;
        Intrinsics.checkNotNullParameter((Object)$this$toSdk, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toSdk.ordinal()]) {
            case 1: {
                type = ContourDetector.Type.ML_BASED;
                break;
            }
            case 2: {
                type = ContourDetector.Type.EDGE_BASED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type;
    }

    @NotNull
    public static final AESEncryptedFileIOProcessor.AESEncrypterMode toSdk(@NotNull JsonFileEncryptionMode $this$toSdk) {
        AESEncryptedFileIOProcessor.AESEncrypterMode aESEncrypterMode;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSdk), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toSdk.ordinal()]) {
            case 1: {
                aESEncrypterMode = AESEncryptedFileIOProcessor.AESEncrypterMode.AES128;
                break;
            }
            case 2: {
                aESEncrypterMode = AESEncryptedFileIOProcessor.AESEncrypterMode.AES256;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return aESEncrypterMode;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[JsonStorageImageFormat.values().length];
            nArray[JsonStorageImageFormat.JPG.ordinal()] = 1;
            nArray[JsonStorageImageFormat.PNG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JsonDocumentDetectorMode.values().length];
            nArray[JsonDocumentDetectorMode.ML_BASED.ordinal()] = 1;
            nArray[JsonDocumentDetectorMode.EDGE_BASED.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JsonFileEncryptionMode.values().length];
            nArray[JsonFileEncryptionMode.AES128.ordinal()] = 1;
            nArray[JsonFileEncryptionMode.AES256.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

