/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.TextDataScannerComponent;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.TextDataScannerCameraViewModule;
import io.scanbot.sdk.ui.di.modules.TextDataScannerCameraViewModule_ProvideTextDataScannerViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.generictext.BaseTextDataScannerActivity;
import io.scanbot.sdk.ui.view.generictext.BaseTextDataScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerActivity;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerCameraViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerTextDataScannerComponent {
    private DaggerTextDataScannerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TextDataScannerCameraViewModule textDataScannerCameraViewModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder textDataScannerCameraViewModule(TextDataScannerCameraViewModule textDataScannerCameraViewModule) {
            this.textDataScannerCameraViewModule = (TextDataScannerCameraViewModule)Preconditions.checkNotNull((Object)textDataScannerCameraViewModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public TextDataScannerComponent build() {
            if (this.textDataScannerCameraViewModule == null) {
                this.textDataScannerCameraViewModule = new TextDataScannerCameraViewModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new TextDataScannerComponentImpl(this.textDataScannerCameraViewModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }

    private static final class TextDataScannerComponentImpl
    implements TextDataScannerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final TextDataScannerComponentImpl textDataScannerComponentImpl = this;
        private Provider<GenericTextRecognizer> genericTextRecognizerProvider;
        private Provider<ViewModel> provideTextDataScannerViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private TextDataScannerComponentImpl(TextDataScannerCameraViewModule textDataScannerCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(textDataScannerCameraViewModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(TextDataScannerCameraViewModule textDataScannerCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.genericTextRecognizerProvider = new GenericTextRecognizerProvider(sDKUIComponentParam);
            this.provideTextDataScannerViewModelProvider = DoubleCheck.provider((Provider)TextDataScannerCameraViewModule_ProvideTextDataScannerViewModelFactory.create(textDataScannerCameraViewModuleParam, this.genericTextRecognizerProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(TextDataScannerCameraViewModel.class, this.provideTextDataScannerViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(TextDataScannerActivity textDataScannerActivity) {
            this.injectTextDataScannerActivity(textDataScannerActivity);
        }

        private TextDataScannerActivity injectTextDataScannerActivity(TextDataScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseTextDataScannerActivity_MembersInjector.injectFactory((BaseTextDataScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class GenericTextRecognizerProvider
        implements Provider<GenericTextRecognizer> {
            private final SDKUIComponent sDKUIComponent;

            GenericTextRecognizerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public GenericTextRecognizer get() {
                return (GenericTextRecognizer)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.genericTextRecognizer());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

