/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.mcrecognizer.MedicalCertificateRecognizer;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.MedicalCertificateRecognizerComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.MedicalCertificateCameraViewModule;
import io.scanbot.sdk.ui.di.modules.MedicalCertificateCameraViewModule_ProvideMedicalCertificateRecognizerResultRepository$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.MedicalCertificateCameraViewModule_ProvideMedicalCertificateRecognizerViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.mc.BaseMedicalCertificateRecognizerActivity;
import io.scanbot.sdk.ui.view.mc.BaseMedicalCertificateRecognizerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.mc.MedicalCertificateCameraViewModel;
import io.scanbot.sdk.ui.view.mc.MedicalCertificateRecognizerActivity;
import java.util.Map;
import java.util.Set;

@DaggerGenerated
public final class DaggerMedicalCertificateRecognizerComponent {
    private DaggerMedicalCertificateRecognizerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MedicalCertificateCameraViewModule medicalCertificateCameraViewModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder medicalCertificateCameraViewModule(MedicalCertificateCameraViewModule medicalCertificateCameraViewModule) {
            this.medicalCertificateCameraViewModule = (MedicalCertificateCameraViewModule)Preconditions.checkNotNull((Object)medicalCertificateCameraViewModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public MedicalCertificateRecognizerComponent build() {
            if (this.medicalCertificateCameraViewModule == null) {
                this.medicalCertificateCameraViewModule = new MedicalCertificateCameraViewModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new MedicalCertificateRecognizerComponentImpl(this.medicalCertificateCameraViewModule, this.viewModelFactoryModule, this.permissionsModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class MedicalCertificateRecognizerComponentImpl
    implements MedicalCertificateRecognizerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final MedicalCertificateRecognizerComponentImpl medicalCertificateRecognizerComponentImpl = this;
        private Provider<MedicalCertificateRecognizer> mcScannerProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Set<ResultRepository<Object>>> resultRepositoriesProvider;
        private Provider<ResultRepository<Object>> provideMedicalCertificateRecognizerResultRepository$rtu_ui_bundle_releaseProvider;
        private Provider<ViewModel> provideMedicalCertificateRecognizerViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider2;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private MedicalCertificateRecognizerComponentImpl(MedicalCertificateCameraViewModule medicalCertificateCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(medicalCertificateCameraViewModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(MedicalCertificateCameraViewModule medicalCertificateCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.mcScannerProvider = new McScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.resultRepositoriesProvider = new ResultRepositoriesProvider(sDKUIComponentParam);
            this.provideMedicalCertificateRecognizerResultRepository$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)MedicalCertificateCameraViewModule_ProvideMedicalCertificateRecognizerResultRepository$rtu_ui_bundle_releaseFactory.create(medicalCertificateCameraViewModuleParam, this.resultRepositoriesProvider));
            this.provideMedicalCertificateRecognizerViewModelProvider = DoubleCheck.provider((Provider)MedicalCertificateCameraViewModule_ProvideMedicalCertificateRecognizerViewModelFactory.create(medicalCertificateCameraViewModuleParam, this.mcScannerProvider, this.provideBarcodeCameraViewModelProvider, this.provideMedicalCertificateRecognizerResultRepository$rtu_ui_bundle_releaseProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider2 = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(MedicalCertificateCameraViewModel.class, this.provideMedicalCertificateRecognizerViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider2).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(MedicalCertificateRecognizerActivity activity) {
            this.injectMedicalCertificateRecognizerActivity(activity);
        }

        private MedicalCertificateRecognizerActivity injectMedicalCertificateRecognizerActivity(MedicalCertificateRecognizerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseMedicalCertificateRecognizerActivity_MembersInjector.injectFactory((BaseMedicalCertificateRecognizerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class McScannerProvider
        implements Provider<MedicalCertificateRecognizer> {
            private final SDKUIComponent sDKUIComponent;

            McScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public MedicalCertificateRecognizer get() {
                return (MedicalCertificateRecognizer)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.mcScanner());
            }
        }

        private static final class ResultRepositoriesProvider
        implements Provider<Set<ResultRepository<Object>>> {
            private final SDKUIComponent sDKUIComponent;

            ResultRepositoriesProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Set<ResultRepository<Object>> get() {
                return (Set)Preconditions.checkNotNullFromComponent(this.sDKUIComponent.resultRepositories());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

