/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.BatchBarcodeCameraComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.BarcodeModule;
import io.scanbot.sdk.ui.di.modules.BarcodeModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.BarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideBatchBarcodeListViewModelFactory;
import io.scanbot.sdk.ui.di.modules.BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraViewModel;
import io.scanbot.sdk.ui.view.barcode.BarcodeScanningSession;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListViewModel;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase_Factory;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase_Factory;
import java.util.Map;

@DaggerGenerated
public final class DaggerBatchBarcodeCameraComponent {
    private DaggerBatchBarcodeCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BarcodeModule barcodeModule;
        private BatchBarcodeModule batchBarcodeModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder barcodeModule(BarcodeModule barcodeModule) {
            this.barcodeModule = (BarcodeModule)Preconditions.checkNotNull((Object)barcodeModule);
            return this;
        }

        public Builder batchBarcodeModule(BatchBarcodeModule batchBarcodeModule) {
            this.batchBarcodeModule = (BatchBarcodeModule)Preconditions.checkNotNull((Object)batchBarcodeModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public BatchBarcodeCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.barcodeModule, BarcodeModule.class);
            Preconditions.checkBuilderRequirement((Object)this.batchBarcodeModule, BatchBarcodeModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new BatchBarcodeCameraComponentImpl(this.barcodeModule, this.batchBarcodeModule, this.viewModelFactoryModule, this.permissionsModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class BatchBarcodeCameraComponentImpl
    implements BatchBarcodeCameraComponent {
        private final SDKUIComponent sDKUIComponent;
        private final BatchBarcodeCameraComponentImpl batchBarcodeCameraComponentImpl = this;
        private Provider<BarcodeScanner> barcodeScannerProvider;
        private Provider<BarcodeFileStorage> barcodeFileStorageProvider;
        private Provider<ImageFileIOProcessor> imageFileIOProcessorProvider;
        private Provider<SaveBarcodeTakenPictureUseCase> saveBarcodeTakenPictureUseCaseProvider;
        private Provider<SaveBarcodePreviewFrameUseCase> saveBarcodePreviewFrameUseCaseProvider;
        private Provider<BarcodeScanningSession> provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider2;
        private Provider<FormattedBarcodeDataMapper> provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider;
        private Provider<ViewModel> provideBatchBarcodeListViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider3;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private BatchBarcodeCameraComponentImpl(BarcodeModule barcodeModuleParam, BatchBarcodeModule batchBarcodeModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(barcodeModuleParam, batchBarcodeModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(BarcodeModule barcodeModuleParam, BatchBarcodeModule batchBarcodeModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.barcodeScannerProvider = new BarcodeScannerProvider(sDKUIComponentParam);
            this.barcodeFileStorageProvider = new BarcodeFileStorageProvider(sDKUIComponentParam);
            this.imageFileIOProcessorProvider = new ImageFileIOProcessorProvider(sDKUIComponentParam);
            this.saveBarcodeTakenPictureUseCaseProvider = SaveBarcodeTakenPictureUseCase_Factory.create(this.barcodeFileStorageProvider, this.imageFileIOProcessorProvider);
            this.saveBarcodePreviewFrameUseCaseProvider = SaveBarcodePreviewFrameUseCase_Factory.create(this.barcodeFileStorageProvider, this.imageFileIOProcessorProvider);
            this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BarcodeModule_ProvideBarcodeScanningSession$rtu_ui_bundle_releaseFactory.create(barcodeModuleParam));
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideBarcodeCameraViewModelProvider2 = DoubleCheck.provider((Provider)BarcodeModule_ProvideBarcodeCameraViewModelFactory.create(barcodeModuleParam, this.barcodeScannerProvider, this.saveBarcodeTakenPictureUseCaseProvider, this.saveBarcodePreviewFrameUseCaseProvider, this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider));
            this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseFactory.create(batchBarcodeModuleParam));
            this.provideBatchBarcodeListViewModelProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideBatchBarcodeListViewModelFactory.create(batchBarcodeModuleParam, this.provideFormattedBarcodeDataMapper$rtu_ui_bundle_releaseProvider, this.provideBarcodeScanningSession$rtu_ui_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider3 = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)3).put(BarcodeCameraViewModel.class, this.provideBarcodeCameraViewModelProvider2).put(BatchBarcodeListViewModel.class, this.provideBatchBarcodeListViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider3).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(BatchBarcodeScannerActivity batchBarcodeActivity) {
            this.injectBatchBarcodeScannerActivity(batchBarcodeActivity);
        }

        private BatchBarcodeScannerActivity injectBatchBarcodeScannerActivity(BatchBarcodeScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseBarcodeScannerActivity_MembersInjector.injectFactory((BaseBarcodeScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class BarcodeScannerProvider
        implements Provider<BarcodeScanner> {
            private final SDKUIComponent sDKUIComponent;

            BarcodeScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public BarcodeScanner get() {
                return (BarcodeScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.barcodeScanner());
            }
        }

        private static final class BarcodeFileStorageProvider
        implements Provider<BarcodeFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            BarcodeFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public BarcodeFileStorage get() {
                return (BarcodeFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.barcodeFileStorage());
            }
        }

        private static final class ImageFileIOProcessorProvider
        implements Provider<ImageFileIOProcessor> {
            private final SDKUIComponent sDKUIComponent;

            ImageFileIOProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public ImageFileIOProcessor get() {
                return (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.imageFileIOProcessor());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

