/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.docprocessing.legacy.PageProcessor;
import io.scanbot.sdk.document.DocumentScanner;
import io.scanbot.sdk.persistence.page.legacy.PageFileStorage;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.di.components.EditPolygonComponent;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.modules.DispatchersModule;
import io.scanbot.sdk.ui.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.EditPolygonModule;
import io.scanbot.sdk.ui.di.modules.EditPolygonModule_ProvideCropAndRotateUseCaseFactory;
import io.scanbot.sdk.ui.di.modules.EditPolygonModule_ProvideDetectPolygonOnPageUseCaseFactory;
import io.scanbot.sdk.ui.di.modules.EditPolygonModule_ProvideEditPolygonViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.edit.BaseCroppingActivity;
import io.scanbot.sdk.ui.view.edit.BaseCroppingActivity_MembersInjector;
import io.scanbot.sdk.ui.view.edit.CroppingActivity;
import io.scanbot.sdk.ui.view.edit.EditPolygonViewModel;
import io.scanbot.sdk.ui.view.interactor.CropAndRotateUseCase;
import io.scanbot.sdk.ui.view.interactor.DetectPolygonOnPageUseCase;
import java.util.Map;

@DaggerGenerated
public final class DaggerEditPolygonComponent {
    private DaggerEditPolygonComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ViewModelFactoryModule viewModelFactoryModule;
        private EditPolygonModule editPolygonModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder editPolygonModule(EditPolygonModule editPolygonModule) {
            this.editPolygonModule = (EditPolygonModule)Preconditions.checkNotNull((Object)editPolygonModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public EditPolygonComponent build() {
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.editPolygonModule, EditPolygonModule.class);
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new EditPolygonComponentImpl(this.viewModelFactoryModule, this.editPolygonModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class EditPolygonComponentImpl
    implements EditPolygonComponent {
        private final SDKUIComponent sDKUIComponent;
        private final EditPolygonComponentImpl editPolygonComponentImpl = this;
        private Provider<PageProcessor> pageProcessorProvider;
        private Provider<CropAndRotateUseCase> provideCropAndRotateUseCaseProvider;
        private Provider<DocumentScanner> documentScannerProvider;
        private Provider<PageFileStorage> pageFileStorageProvider;
        private Provider<DetectPolygonOnPageUseCase> provideDetectPolygonOnPageUseCaseProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<ViewModel> provideEditPolygonViewModelProvider;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private EditPolygonComponentImpl(ViewModelFactoryModule viewModelFactoryModuleParam, EditPolygonModule editPolygonModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(viewModelFactoryModuleParam, editPolygonModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private void initialize(ViewModelFactoryModule viewModelFactoryModuleParam, EditPolygonModule editPolygonModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.pageProcessorProvider = new PageProcessorProvider(sDKUIComponentParam);
            this.provideCropAndRotateUseCaseProvider = EditPolygonModule_ProvideCropAndRotateUseCaseFactory.create(editPolygonModuleParam, this.pageProcessorProvider);
            this.documentScannerProvider = new DocumentScannerProvider(sDKUIComponentParam);
            this.pageFileStorageProvider = new PageFileStorageProvider(sDKUIComponentParam);
            this.provideDetectPolygonOnPageUseCaseProvider = EditPolygonModule_ProvideDetectPolygonOnPageUseCaseFactory.create(editPolygonModuleParam, this.documentScannerProvider, this.pageFileStorageProvider);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideEditPolygonViewModelProvider = DoubleCheck.provider((Provider)EditPolygonModule_ProvideEditPolygonViewModelFactory.create(editPolygonModuleParam, this.provideCropAndRotateUseCaseProvider, this.provideDetectPolygonOnPageUseCaseProvider, this.provideBarcodeCameraViewModelProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)1).put(EditPolygonViewModel.class, this.provideEditPolygonViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(CroppingActivity croppingActivity) {
            this.injectCroppingActivity(croppingActivity);
        }

        private CroppingActivity injectCroppingActivity(CroppingActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseCroppingActivity_MembersInjector.injectFactory((BaseCroppingActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            BaseCroppingActivity_MembersInjector.injectSapManager((BaseCroppingActivity)instance, (SapManager)((SapManager)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.sapManager())));
            return instance;
        }

        private static final class PageProcessorProvider
        implements Provider<PageProcessor> {
            private final SDKUIComponent sDKUIComponent;

            PageProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageProcessor get() {
                return (PageProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageProcessor());
            }
        }

        private static final class DocumentScannerProvider
        implements Provider<DocumentScanner> {
            private final SDKUIComponent sDKUIComponent;

            DocumentScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentScanner get() {
                return (DocumentScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentScanner());
            }
        }

        private static final class PageFileStorageProvider
        implements Provider<PageFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            PageFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageFileStorage get() {
                return (PageFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageFileStorage());
            }
        }
    }
}

