/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.textpattern.TextPatternScanner;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.di.components.SDKUIComponent;
import io.scanbot.sdk.ui.di.components.TextPatternScannerComponent;
import io.scanbot.sdk.ui.di.modules.PermissionsModule;
import io.scanbot.sdk.ui.di.modules.PermissionsModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui.di.modules.TextPatternScannerCameraViewModule;
import io.scanbot.sdk.ui.di.modules.TextPatternScannerCameraViewModule_ProvideTextPatternScannerViewModelFactory;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui.view.base.NFBaseActivity;
import io.scanbot.sdk.ui.view.base.NFBaseActivity_MembersInjector;
import io.scanbot.sdk.ui.view.base.PermissionViewModel;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase_Factory;
import io.scanbot.sdk.ui.view.textpattern.BaseTextPatternScannerActivity;
import io.scanbot.sdk.ui.view.textpattern.BaseTextPatternScannerActivity_MembersInjector;
import io.scanbot.sdk.ui.view.textpattern.TextPatternScannerActivity;
import io.scanbot.sdk.ui.view.textpattern.TextPatternScannerCameraViewModel;
import java.util.Map;

@DaggerGenerated
public final class DaggerTextPatternScannerComponent {
    private DaggerTextPatternScannerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TextPatternScannerCameraViewModule textPatternScannerCameraViewModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private PermissionsModule permissionsModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder textPatternScannerCameraViewModule(TextPatternScannerCameraViewModule textPatternScannerCameraViewModule) {
            this.textPatternScannerCameraViewModule = (TextPatternScannerCameraViewModule)Preconditions.checkNotNull((Object)textPatternScannerCameraViewModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder permissionsModule(PermissionsModule permissionsModule) {
            this.permissionsModule = (PermissionsModule)Preconditions.checkNotNull((Object)permissionsModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public TextPatternScannerComponent build() {
            if (this.textPatternScannerCameraViewModule == null) {
                this.textPatternScannerCameraViewModule = new TextPatternScannerCameraViewModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.permissionsModule == null) {
                this.permissionsModule = new PermissionsModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new TextPatternScannerComponentImpl(this.textPatternScannerCameraViewModule, this.viewModelFactoryModule, this.permissionsModule, this.sDKUIComponent);
        }
    }

    private static final class TextPatternScannerComponentImpl
    implements TextPatternScannerComponent {
        private final SDKUIComponent sDKUIComponent;
        private final TextPatternScannerComponentImpl textPatternScannerComponentImpl = this;
        private Provider<TextPatternScanner> textPatternScannerProvider;
        private Provider<ViewModel> provideTextPatternScannerViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<CheckCameraPermissionUseCase> checkCameraPermissionUseCaseProvider;
        private Provider<ViewModel> provideBarcodeCameraViewModelProvider;
        private Provider mapOfClassOfAndProviderOfViewModelProvider;
        private Provider<ViewModelProvider.Factory> bindViewModelFactoryProvider;

        private TextPatternScannerComponentImpl(TextPatternScannerCameraViewModule textPatternScannerCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(textPatternScannerCameraViewModuleParam, viewModelFactoryModuleParam, permissionsModuleParam, sDKUIComponentParam);
        }

        private void initialize(TextPatternScannerCameraViewModule textPatternScannerCameraViewModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, PermissionsModule permissionsModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.textPatternScannerProvider = new TextPatternScannerProvider(sDKUIComponentParam);
            this.provideTextPatternScannerViewModelProvider = DoubleCheck.provider((Provider)TextPatternScannerCameraViewModule_ProvideTextPatternScannerViewModelFactory.create(textPatternScannerCameraViewModuleParam, this.textPatternScannerProvider));
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.checkCameraPermissionUseCaseProvider = CheckCameraPermissionUseCase_Factory.create(this.provideContextProvider);
            this.provideBarcodeCameraViewModelProvider = DoubleCheck.provider((Provider)PermissionsModule_ProvideBarcodeCameraViewModelFactory.create(permissionsModuleParam, this.checkCameraPermissionUseCaseProvider));
            this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(TextPatternScannerCameraViewModel.class, this.provideTextPatternScannerViewModelProvider).put(PermissionViewModel.class, this.provideBarcodeCameraViewModelProvider).build();
            this.bindViewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactoryModule_BindViewModelFactoryFactory.create(viewModelFactoryModuleParam, (javax.inject.Provider<Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>>>)this.mapOfClassOfAndProviderOfViewModelProvider));
        }

        @Override
        public void inject(TextPatternScannerActivity textPatternScannerActivity) {
            this.injectTextPatternScannerActivity(textPatternScannerActivity);
        }

        private TextPatternScannerActivity injectTextPatternScannerActivity(TextPatternScannerActivity instance) {
            NFBaseActivity_MembersInjector.injectCameraUiSettings((NFBaseActivity)instance, (CameraUiSettings)((CameraUiSettings)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.cameraUiSettings())));
            BaseTextPatternScannerActivity_MembersInjector.injectFactory((BaseTextPatternScannerActivity)instance, (ViewModelProvider.Factory)((ViewModelProvider.Factory)this.bindViewModelFactoryProvider.get()));
            return instance;
        }

        private static final class TextPatternScannerProvider
        implements Provider<TextPatternScanner> {
            private final SDKUIComponent sDKUIComponent;

            TextPatternScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public TextPatternScanner get() {
                return (TextPatternScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.textPatternScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

