/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import com.googlecode.leptonica.android.Convert;
import com.googlecode.leptonica.android.Pix;
import java.io.File;

public class WriteFile {
    public static byte[] writeBytes8(Pix pixs) {
        if (pixs != null) {
            Pix pix;
            Pix pix2 = pix;
            int n = pix2.getWidth();
            byte[] byArray = new byte[pix2.getHeight() * n];
            if (pix2.getDepth() != 8) {
                Pix pix3 = Convert.convertTo8(pix);
                WriteFile.writeBytes8(pix3, byArray);
                pix3.recycle();
                return byArray;
            }
            WriteFile.writeBytes8(pix, byArray);
            return byArray;
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    /*
     * WARNING - void declaration
     */
    public static int writeBytes8(Pix pixs, byte[] data) {
        if (pixs != null) {
            void var1_1;
            Pix pix;
            Pix pix2 = pix;
            int n = pix2.getWidth();
            n = pix2.getHeight() * n;
            if (((void)var1_1).length >= n) {
                return WriteFile.nativeWriteBytes8(pix.getNativePix(), (byte[])var1_1);
            }
            throw new IllegalArgumentException("Data array must be large enough to hold image bytes");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean writeImpliedFormat(Pix pixs, File file) {
        if (pixs != null) {
            void var1_1;
            if (var1_1 != null) {
                Pix pix;
                return WriteFile.nativeWriteImpliedFormat(pix.getNativePix(), var1_1.getAbsolutePath());
            }
            throw new IllegalArgumentException("File must be non-null");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Bitmap writeBitmap(Pix pixs) {
        if (pixs != null) {
            Pix pix;
            int[] nArray = pix.getDimensions();
            if (nArray != null) {
                Pix pix2 = pix;
                pix = Bitmap.createBitmap((int)nArray[0], (int)nArray[1], (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (WriteFile.nativeWriteBitmap(pix2.getNativePix(), (Bitmap)pix)) {
                    return pix;
                }
                pix.recycle();
            }
            return null;
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native int nativeWriteBytes8(long var0, byte[] var2);

    private static native boolean nativeWriteImpliedFormat(long var0, String var2);

    private static native boolean nativeWriteBitmap(long var0, Bitmap var2);
}

