/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import io.scanbot.sdk.util.log.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001a\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001b\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010\u001b\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001dJ$\u0010\u001e\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001f\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010 \u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010!\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016J$\u0010#\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0010\u0010*\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010*\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/util/log/DebugLog;", "Lio/scanbot/sdk/util/log/Logger;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callerClassName", "", "getCallerClassName", "()Ljava/lang/String;", "callerMethodName", "getCallerMethodName", "logFilename", "getLogFilename", "logWriter", "Ljava/io/Writer;", "getLogWriter", "()Ljava/io/Writer;", "buildLogMessage", "tag", "message", "level", "Lio/scanbot/sdk/util/log/Logger$Level;", "closeSafely", "", "closeable", "Ljava/io/Closeable;", "d", "e", "where", "", "echoMessage", "i", "logException", "logMessage", "logMethod", "logToFile", "prepareLogsFolder", "externalStorage", "Ljava/io/File;", "printVersionInfo", "tokenizeClassName", "className", "w", "Companion", "core-base_release"})
@SourceDebugExtension(value={"SMAP\nDebugLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugLog.kt\nio/scanbot/sdk/util/log/DebugLog\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,281:1\n107#2:282\n79#2,22:283\n*S KotlinDebug\n*F\n+ 1 DebugLog.kt\nio/scanbot/sdk/util/log/DebugLog\n*L\n203#1:282\n203#1:283,22\n*E\n"})
public final class DebugLog
implements Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LOG_DIRECTORY = "debug_logs";
    @NotNull
    public static final String LOG_EXTENSION = ".txt";
    @NotNull
    private static final String LOG_FIELD_SEPARATOR = " | ";
    @NotNull
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    @NotNull
    private static final String DEFAULT_PACKAGE_NAME = "default";
    @NotNull
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    @NotNull
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared;
    private static final boolean savingEnabled = true;
    private static final boolean echoEnabled = true;
    @NotNull
    private static final Logger.Level savingLevel;
    @NotNull
    private static final Logger.Level echoLevel;
    @NotNull
    private static String packageName;

    /*
     * WARNING - void declaration
     */
    public DebugLog(@Nullable Context context) {
        prepared = true;
        if (context != null) {
            void var1_1;
            String string = var1_1.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            packageName = string;
            this.printVersionInfo((Context)var1_1);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void printVersionInfo(Context context) {
        Object object;
        block5: {
            PackageManager.NameNotFoundException nameNotFoundException2;
            block4: {
                String string;
                PackageInfo packageInfo;
                try {
                    packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
                    int n = packageInfo.applicationInfo.labelRes;
                    string = n != 0 ? object.getString(n) : UNKNOWN_SIGNATURE;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                    break block4;
                }
                object = string;
                String string2 = object;
                PackageInfo packageInfo2 = packageInfo;
                object = packageInfo2.versionName;
                object = string2 + " v" + (String)object + " #" + packageInfo2.versionCode;
                break block5;
            }
            this.logException(nameNotFoundException2);
            object = NO_APPLICATION_INFO_MESSAGE;
        }
        this.i("APP_INFO", (String)object);
    }

    /*
     * WARNING - void declaration
     */
    private final void logMessage(String tag, String message, Logger.Level level) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (!prepared) {
            return;
        }
        if (var3_3.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage((String)var1_1, (String)var2_2, (Logger.Level)var3_3);
        }
        if (var3_3.ordinal() >= savingLevel.ordinal()) {
            this.logToFile((String)var1_1, (String)var2_2, (Logger.Level)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void echoMessage(String tag, String message, Logger.Level level) {
        void var3_3;
        String string;
        if (message == null) {
            string = "NULL (no log message)";
        }
        switch (WhenMappings.$EnumSwitchMapping$0[var3_3.ordinal()]) {
            default: {
                break;
            }
            case 5: {
                void var1_1;
                Log.v((String)var1_1, (String)string);
                break;
            }
            case 4: {
                void var1_1;
                Log.i((String)var1_1, (String)string);
                break;
            }
            case 3: {
                void var1_1;
                Log.w((String)var1_1, (String)string);
                break;
            }
            case 2: {
                void var1_1;
                Log.e((String)var1_1, (String)string);
                break;
            }
            case 1: {
                void var1_1;
                Log.d((String)var1_1, (String)string);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void logToFile(String tag, String message, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer == null) return;
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            Writer writer2 = writer;
            writer2.write(this.buildLogMessage((String)var1_1, (String)var2_2, (Logger.Level)var3_3));
            this.closeSafely(writer2);
        }
        catch (IOException iOException) {}
        finally {
            return;
        }
    }

    private final void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - void declaration
     */
    private final String buildLogMessage(String tag, String message, Logger.Level level) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (tag == null || (object = StringsKt.replace$default((String)var1_1, (char)'|', (char)'/', (boolean)false, (int)4, null)) == null) {
            Object object = "";
        }
        return StringsKt.trimIndent((String)("\n            " + TIME_FORMAT.format(new Date()) + (Logger.Level)var3_3 + LOG_FIELD_SEPARATOR + (String)object + LOG_FIELD_SEPARATOR + (String)var2_2 + "\n\n            "));
    }

    private final Writer getLogWriter() {
        FileWriter fileWriter;
        File file;
        FileWriter fileWriter2 = null;
        File file2 = Environment.getExternalStorageDirectory();
        Intrinsics.checkNotNull((Object)file2);
        ((DebugLog)((Object)this_)).prepareLogsFolder(file2);
        File file3 = file;
        file = new File(file2, ((DebugLog)((Object)this_)).getLogFilename());
        FileWriter this_ = fileWriter;
        try {
            fileWriter = new FileWriter(file3, true);
            fileWriter2 = this_;
        }
        catch (IOException iOException) {}
        return fileWriter2;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareLogsFolder(File externalStorage) {
        void var1_1;
        File file;
        File file2 = file;
        if (!new File((File)var1_1, LOG_DIRECTORY).exists()) {
            file2.mkdirs();
        }
    }

    private final String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String tokenizeClassName(String className) {
        this = v0;
        v0 = new ArrayList<E>();
        try {
            var2_2 = DebugLog.CLASS_NAME_PATTERN.matcher((CharSequence)var1_1);
lbl5:
            // 3 sources

            while (var2_2.find()) {
                v1 = var2_2;
                var3_4 = v1.start();
                var3_3 = var1_1.substring(var3_4, v1.end());
                ** GOTO lbl-1000
            }
            ** GOTO lbl-1000
        }
        catch (Exception v2) {
            return var1_1;
        }
lbl-1000:
        // 1 sources

        {
            Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"substring(...)");
            var4_5 = 0;
            var5_6 = var3_3.length() - 1;
            var6_7 = false;
        }
        while (var4_5 <= var5_6) {
            var7_8 = var6_7 == false ? var4_5 : var5_6;
            {
                var7_8 = Intrinsics.compare((int)var3_3.charAt(var7_8), (int)32) <= 0 ? 1 : 0;
                if (!var6_7) {
                    if (var7_8 == 0) {
                        var6_7 = true;
                        continue;
                    }
                    ++var4_5;
                    continue;
                }
                if (var7_8 == 0) break;
                --var5_6;
            }
        }
        {
            if (TextUtils.isEmpty((CharSequence)var3_3.subSequence(var4_5, var5_6 + 1).toString())) ** GOTO lbl5
            v3 = var3_3.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toUpperCase(...)");
            this.add(v3);
        }
        ** GOTO lbl5
lbl-1000:
        // 1 sources

        {
            this = this.isEmpty() != false ? var1_1 : TextUtils.join((CharSequence)"_", (Iterable)this);
            Intrinsics.checkNotNull((Object)this);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getCallerClassName() {
        block8: {
            var1_1 = 4;
            try {
                var2_3 = Thread.currentThread().getStackTrace();
            }
            catch (Exception v0) {
                break block8;
            }
            {
                if (var2_3.length <= var1_1) ** GOTO lbl19
                var1_2 = var2_3[var1_1].getClassName();
            }
            {
                Intrinsics.checkNotNull((Object)var1_2);
                var2_4 = StringsKt.lastIndexOf$default((CharSequence)var1_2, (String)".", (int)0, (boolean)false, (int)6, null);
            }
            {
                if (var2_4 < 0 || ++var2_4 >= var1_2.length()) ** GOTO lbl-1000
                var1_2 = var1_2.substring(var2_4);
            }
            {
                Intrinsics.checkNotNullExpressionValue((Object)var1_2, (String)"substring(...)");
                return this.tokenizeClassName(var1_2);
            }
lbl-1000:
            // 1 sources

            {
                v1 = "[unknown]";
lbl16:
                // 2 sources

                while (true) {
                    var1_2 = v1;
                    return this.tokenizeClassName(var1_2);
                }
lbl19:
                // 1 sources

                v1 = "[unknown]";
                ** continue;
            }
        }
        var1_2 = "[unknown]";
        return this.tokenizeClassName(var1_2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getCallerMethodName() {
        String string;
        int n = 4;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            string = stackTraceElementArray.length > n ? stackTraceElementArray[n].getMethodName() : UNKNOWN_SIGNATURE;
        }
        catch (Exception exception) {
            return UNKNOWN_SIGNATURE;
        }
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    static {
        echoLevel = savingLevel = Logger.Level.Verbose;
        packageName = DEFAULT_PACKAGE_NAME;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void d(@Nullable String tag, @Nullable String message) {
        void var2_2;
        void var1_1;
        DebugLog debugLog = this_;
        Object this_ = Logger.Level.Debug;
        debugLog.logMessage((String)var1_1, (String)var2_2, (Logger.Level)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void w(@Nullable String tag, @Nullable String message) {
        void var2_2;
        void var1_1;
        DebugLog debugLog = this_;
        Object this_ = Logger.Level.Warning;
        debugLog.logMessage((String)var1_1, (String)var2_2, (Logger.Level)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void e(@Nullable String tag, @Nullable String message) {
        void var2_2;
        void var1_1;
        DebugLog debugLog = this_;
        Object this_ = Logger.Level.Error;
        debugLog.logMessage((String)var1_1, (String)var2_2, (Logger.Level)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void i(@Nullable String tag, @Nullable String message) {
        void var2_2;
        void var1_1;
        DebugLog debugLog = this_;
        Object this_ = Logger.Level.Information;
        debugLog.logMessage((String)var1_1, (String)var2_2, (Logger.Level)((Object)this_));
    }

    /*
     * WARNING - void declaration
     */
    public final void e(@Nullable String tag, @Nullable String where, @NotNull Throwable e) {
        void var1_1;
        void var2_2;
        void var3_3;
        DebugLog debugLog = this_;
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"e");
        String this_ = "Exception in " + (String)var2_2 + ": " + var3_3.getClass().getName() + LOG_FIELD_SEPARATOR + var3_3.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"toString(...)");
        debugLog.e((String)var1_1, this_);
    }

    /*
     * WARNING - void declaration
     */
    public final void d(@Nullable String message) {
        void var1_1;
        DebugLog debugLog = this;
        debugLog.d(debugLog.getCallerClassName(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void i(@Nullable String message) {
        void var1_1;
        DebugLog debugLog = this;
        debugLog.i(debugLog.getCallerClassName(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void w(@Nullable String message) {
        void var1_1;
        DebugLog debugLog = this;
        debugLog.w(debugLog.getCallerClassName(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void e(@Nullable String message) {
        void var1_1;
        DebugLog debugLog = this;
        debugLog.e(debugLog.getCallerClassName(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logException(@Nullable Throwable e) {
        void var1_1;
        if (!prepared) {
            return;
        }
        DebugLog debugLog = exception2;
        String string = debugLog.getCallerClassName();
        String string2 = debugLog.getCallerMethodName();
        if (var1_1 != null) {
            ((DebugLog)((Object)exception2)).e(string, string2, (Throwable)var1_1);
        } else {
            Exception exception;
            DebugLog debugLog2 = exception2;
            Exception exception2 = exception;
            exception = new Exception("Unknown exception");
            debugLog2.e(string, string2, exception2);
        }
    }

    @Override
    public void logMethod() {
        if (!prepared) {
            return;
        }
        DebugLog debugLog = string;
        String string = debugLog.getCallerClassName();
        debugLog.i(string, debugLog.getCallerMethodName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/util/log/DebugLog$Companion;", "", "()V", "CLASS_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "DEFAULT_PACKAGE_NAME", "", "LOG_DIRECTORY", "LOG_EXTENSION", "LOG_FIELD_SEPARATOR", "NO_APPLICATION_INFO_MESSAGE", "TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "UNKNOWN_SIGNATURE", "echoEnabled", "", "echoLevel", "Lio/scanbot/sdk/util/log/Logger$Level;", "packageName", "prepared", "savingEnabled", "savingLevel", "core-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Logger.Level.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Logger.Level.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Logger.Level.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Logger.Level.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Logger.Level.Information.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Logger.Level.Verbose.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

