/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.core;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.common.JsonKt;
import io.scanbot.sdk.common.ByteArrayJson;
import io.scanbot.sdk.common.ByteArrayJsonKt;
import io.scanbot.sdk.common.ImageSerializationMode;
import io.scanbot.sdk.core.BasicImageLoadOptions;
import io.scanbot.sdk.core.BufferImageLoadOptions;
import io.scanbot.sdk.core.BufferLoadMode;
import io.scanbot.sdk.core.EncodeImageOptions;
import io.scanbot.sdk.core.ImageInfo;
import io.scanbot.sdk.core.PathImageLoadOptions;
import io.scanbot.sdk.core.RawImageLoadOptions;
import io.scanbot.sdk.core.SaveImageOptions;
import io.scanbot.sdk.persistence.fileio.CoreStreamProvider;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parceler;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0000H\u0086 J\b\u0010\u000f\u001a\u00020\fH\u0016J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086 J\u0013\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\fH\u0004J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\t\u0010\u001b\u001a\u00020\fH\u0086 J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0086 J\u001b\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0014\u001a\u00020!H\u0086 J\u0006\u0010\"\u001a\u00020 J\u000b\u0010#\u001a\u0004\u0018\u00010$H\u0086 J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\fH\u0002J\u0019\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u00d6\u0001R\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006/"}, d2={"Lio/scanbot/sdk/core/ImageRef;", "Landroid/os/Parcelable;", "Ljava/lang/AutoCloseable;", "uniqueId", "Ljava/util/UUID;", "acquireStrongReference", "", "(Ljava/util/UUID;Z)V", "<set-?>", "getUniqueId", "()Ljava/util/UUID;", "acquireSerializedReference", "", "clear", "clone", "close", "describeContents", "", "encodeImage", "", "options", "Lio/scanbot/sdk/core/EncodeImageOptions;", "equals", "other", "", "finalize", "hashCode", "hibernate", "info", "Lio/scanbot/sdk/core/ImageInfo;", "saveImage", "path", "", "Lio/scanbot/sdk/core/SaveImageOptions;", "serialize", "toBitmap", "Landroid/graphics/Bitmap;", "toJson", "Lorg/json/JSONObject;", "imageSerializationMode", "Lio/scanbot/sdk/common/ImageSerializationMode;", "upgradeSerializedReference", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "core-common_release"})
@Parcelize
public final class ImageRef
implements Parcelable,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final Parcelable.Creator<ImageRef> CREATOR;
    @Nullable
    private UUID uniqueId;

    /*
     * WARNING - void declaration
     */
    public ImageRef(@NotNull UUID uniqueId, boolean acquireStrongReference) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uniqueId");
        this.uniqueId = var1_1;
        if (acquireStrongReference) {
            void v0 = var1_1;
            Intrinsics.checkNotNull((Object)v0);
            io.scanbot.sdk.core.ImageRef$Companion.access$acquireStrongReference(Companion, (UUID)v0);
        }
    }

    public static /* synthetic */ boolean saveImage$default(ImageRef imageRef, String string, SaveImageOptions saveImageOptions, int n, Object object) {
        if ((n & 2) != 0) {
            SaveImageOptions saveImageOptions2;
            saveImageOptions = saveImageOptions2;
            saveImageOptions2 = new SaveImageOptions(0, null, 3, null);
        }
        return imageRef.saveImage(string, saveImageOptions);
    }

    public static /* synthetic */ byte[] encodeImage$default(ImageRef imageRef, EncodeImageOptions encodeImageOptions, int n, Object object) {
        if ((n & 1) != 0) {
            EncodeImageOptions encodeImageOptions2;
            encodeImageOptions = encodeImageOptions2;
            encodeImageOptions2 = new EncodeImageOptions(0, null, 3, null);
        }
        return imageRef.encodeImage(encodeImageOptions);
    }

    private final void acquireSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        Companion.acquireSerializedReference(uUID);
    }

    private final void upgradeSerializedReference() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        Companion.upgradeSerializedReference(uUID);
    }

    @JvmStatic
    public static final native void releaseAllImages();

    @JvmStatic
    @Nullable
    public static final native ImageRef fromEncodedBuffer(@NotNull byte[] var0, @NotNull BufferImageLoadOptions var1);

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
        void var1_1;
        InputStream inputStream2;
        return Companion.fromInputStream(inputStream2, (BufferImageLoadOptions)var1_1);
    }

    @JvmStatic
    @Nullable
    public static final native ImageRef fromPath(@NotNull String var0, @NotNull PathImageLoadOptions var1);

    @JvmStatic
    @NotNull
    public static final native ImageRef fromBitmap(@NotNull Bitmap var0, @NotNull BasicImageLoadOptions var1);

    @JvmStatic
    @NotNull
    public static final native ImageRef fromNv21(@NotNull byte[] var0, int var1, int var2, @NotNull RawImageLoadOptions var3);

    @JvmStatic
    @NotNull
    public static final ImageRef deserialize(@NotNull String source) {
        String string;
        return Companion.deserialize(string);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
        UUID uUID;
        return Companion.fromSerializedReference(uUID);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
        Map<String, ? extends Object> map;
        return Companion.fromJson(map);
    }

    @JvmStatic
    @NotNull
    public static final ImageRef fromJson(@NotNull JSONObject source) {
        JSONObject jSONObject;
        return Companion.fromJson(jSONObject);
    }

    @JvmStatic
    public static final native void setHibernationJpegQuality(int var0);

    @JvmStatic
    public static final native void setHibernationCacheDirPath(@Nullable String var0);

    @JvmStatic
    public static final native void setStorageCryptingProvider(@Nullable CoreStreamProvider var0);

    @JvmStatic
    public static final native boolean acquireSerializedReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean releaseStrongReference(@NotNull UUID var0);

    @JvmStatic
    public static final native boolean upgradeSerializedReference(@NotNull UUID var0);

    @JvmStatic
    private static final native boolean acquireStrongReference(UUID var0);

    @JvmStatic
    private static final native void clear(UUID var0);

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<ImageRef> {
            @NotNull
            public final ImageRef[] newArray(int size) {
                return new ImageRef[size];
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ImageRef createFromParcel(@NotNull Parcel parcel) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return Companion.create((Parcel)var1_1);
            }
        }
        CREATOR = new Creator();
    }

    @Nullable
    public final UUID getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        UUID this_ = ((ImageRef)((Object)this_)).uniqueId;
        return this_ != null ? ((Object)this_).hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        UUID uUID = ((ImageRef)((Object)uUID)).uniqueId;
        object = other instanceof ImageRef ? (ImageRef)object : null;
        object = object != null ? ((ImageRef)object).uniqueId : null;
        return Intrinsics.areEqual((Object)uUID, (Object)object);
    }

    @Nullable
    public final native ImageRef clone();

    public final native void hibernate();

    public final void clear() {
        UUID uUID = this.uniqueId;
        Intrinsics.checkNotNull((Object)uUID);
        io.scanbot.sdk.core.ImageRef$Companion.access$clear(Companion, uUID);
        this.close();
    }

    @Nullable
    public final native ImageInfo info();

    @Nullable
    public final native Bitmap toBitmap();

    public final native boolean saveImage(@NotNull String var1, @NotNull SaveImageOptions var2);

    @NotNull
    public final native byte[] encodeImage(@NotNull EncodeImageOptions var1);

    @Override
    public void close() {
        UUID uUID = this.uniqueId;
        if (uUID == null) {
            return;
        }
        UUID uUID2 = uUID;
        Intrinsics.checkNotNull((Object)uUID2);
        Companion.releaseStrongReference(uUID2);
        this.uniqueId = null;
    }

    public final void finalize() {
        if (this.uniqueId != null) {
            LoggerProvider.getLogger().d("ScanbotSDK", "ImageRef with unique ID " + this.uniqueId + " was closed by the finalizer. Calling ImageRef.close() as soon as the ImageRef is no longer needed may significantly reduce app memory usage.");
        }
        this.close();
    }

    @NotNull
    public final String serialize() {
        ImageRef imageRef = this;
        imageRef.acquireSerializedReference();
        return String.valueOf(imageRef.uniqueId);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JSONObject toJson(@NotNull ImageSerializationMode imageSerializationMode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)imageSerializationMode), (String)"imageSerializationMode");
        int n = WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
        if (n != 1) {
            JSONObject jSONObject;
            if (n != 2) throw new NoWhenBranchMatchedException();
            ImageRef imageRef = this;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject.put("buffer", (Object)ByteArrayJsonKt.toBase64(ImageRef.encodeImage$default((ImageRef)this, null, 1, null)));
            this = "imageInfo";
            Object object = imageRef.info();
            if (object == null || (object = ImageInfo.toJson$default((ImageInfo)object, null, 1, null)) == null) {
                object = JSONObject.NULL;
            }
            this = jSONObject2.put((String)this, object);
            Intrinsics.checkNotNull((Object)this);
            return this;
        } else {
            this = new JSONObject().put("uniqueId", (Object)((ImageRef)this).serialize());
            Intrinsics.checkNotNull((Object)this);
        }
        return this;
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NotNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Companion.write(this, (Parcel)var1_1, (int)var2_2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\u0011\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0083 J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0083 J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001b\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0087 J\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0014\u001a\u00020\u0019H\u0087 J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0014\u001a\u00020\u0019H\u0007J\u001e\u0010\u001d\u001a\u00020\u00022\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0007J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020 H\u0007J+\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010\u0014\u001a\u00020&H\u0087 J\u001d\u0010'\u001a\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020)H\u0087 J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\t\u0010+\u001a\u00020\nH\u0087 J\u0011\u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\u0013\u0010-\u001a\u00020\n2\b\u0010.\u001a\u0004\u0018\u00010\u0010H\u0087 J\u0011\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020$H\u0087 J\u0013\u00101\u001a\u00020\n2\b\u00102\u001a\u0004\u0018\u000103H\u0087 J\u0011\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\u001c\u00105\u001a\u00020\n*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u00106\u001a\u00020$H\u0016\u00a8\u00067"}, d2={"Lio/scanbot/sdk/core/ImageRef$Companion;", "Lkotlinx/parcelize/Parceler;", "Lio/scanbot/sdk/core/ImageRef;", "()V", "acquireSerializedReference", "", "uniqueId", "Ljava/util/UUID;", "acquireStrongReference", "clear", "", "create", "parcel", "Landroid/os/Parcel;", "deserialize", "source", "", "fromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "options", "Lio/scanbot/sdk/core/BasicImageLoadOptions;", "fromEncodedBuffer", "encodedBuffer", "", "Lio/scanbot/sdk/core/BufferImageLoadOptions;", "fromInputStream", "inputStream", "Ljava/io/InputStream;", "fromJson", "", "", "Lorg/json/JSONObject;", "fromNv21", "nv21", "width", "", "height", "Lio/scanbot/sdk/core/RawImageLoadOptions;", "fromPath", "path", "Lio/scanbot/sdk/core/PathImageLoadOptions;", "fromSerializedReference", "releaseAllImages", "releaseStrongReference", "setHibernationCacheDirPath", "cacheDirPath", "setHibernationJpegQuality", "quality", "setStorageCryptingProvider", "storageCryptingProvider", "Lio/scanbot/sdk/persistence/fileio/CoreStreamProvider;", "upgradeSerializedReference", "write", "flags", "core-common_release"})
    public static final class Companion
    implements Parceler<ImageRef> {
        private Companion() {
        }

        public static /* synthetic */ ImageRef fromEncodedBuffer$default(Companion companion, byte[] byArray, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BufferImageLoadOptions bufferImageLoadOptions2;
                bufferImageLoadOptions = bufferImageLoadOptions2;
                bufferImageLoadOptions2 = new BufferImageLoadOptions(null, null, 3, null);
            }
            return companion.fromEncodedBuffer(byArray, bufferImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromInputStream$default(Companion companion, InputStream inputStream, BufferImageLoadOptions bufferImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BufferImageLoadOptions bufferImageLoadOptions2;
                bufferImageLoadOptions = bufferImageLoadOptions2;
                bufferImageLoadOptions2 = new BufferImageLoadOptions(null, null, 3, null);
            }
            return companion.fromInputStream(inputStream, bufferImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromPath$default(Companion companion, String string, PathImageLoadOptions pathImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                PathImageLoadOptions pathImageLoadOptions2;
                pathImageLoadOptions = pathImageLoadOptions2;
                pathImageLoadOptions2 = new PathImageLoadOptions(null, null, null, 7, null);
            }
            return companion.fromPath(string, pathImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromBitmap$default(Companion companion, Bitmap bitmap, BasicImageLoadOptions basicImageLoadOptions, int n, Object object) {
            if ((n & 2) != 0) {
                BasicImageLoadOptions basicImageLoadOptions2;
                basicImageLoadOptions = basicImageLoadOptions2;
                basicImageLoadOptions2 = new BasicImageLoadOptions(null, 1, null);
            }
            return companion.fromBitmap(bitmap, basicImageLoadOptions);
        }

        public static /* synthetic */ ImageRef fromNv21$default(Companion companion, byte[] byArray, int n, int n2, RawImageLoadOptions rawImageLoadOptions, int n3, Object object) {
            if ((n3 & 8) != 0) {
                RawImageLoadOptions rawImageLoadOptions2;
                rawImageLoadOptions = rawImageLoadOptions2;
                rawImageLoadOptions2 = new RawImageLoadOptions(null, null, 3, null);
            }
            return companion.fromNv21(byArray, n, n2, rawImageLoadOptions);
        }

        @JvmStatic
        private final boolean acquireStrongReference(UUID uniqueId) {
            return ImageRef.acquireStrongReference(uniqueId);
        }

        @JvmStatic
        private final void clear(UUID uniqueId) {
            ImageRef.clear(uniqueId);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$acquireStrongReference(Companion $this, UUID uniqueId) {
            void var1_1;
            return $this.acquireStrongReference((UUID)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$clear(Companion $this, UUID uniqueId) {
            void var1_1;
            $this.clear((UUID)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        public final void releaseAllImages() {
            ImageRef.releaseAllImages();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromEncodedBuffer(@NotNull byte[] encodedBuffer, @NotNull BufferImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromEncodedBuffer(encodedBuffer, (BufferImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromInputStream(@NotNull InputStream inputStream, @NotNull BufferImageLoadOptions options) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"options");
            return this.fromEncodedBuffer(ByteStreamsKt.readBytes((InputStream)var1_1), (BufferImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final ImageRef fromPath(@NotNull String path, @NotNull PathImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromPath(path, (PathImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromBitmap(@NotNull Bitmap bitmap, @NotNull BasicImageLoadOptions options) {
            void var2_2;
            return ImageRef.fromBitmap(bitmap, (BasicImageLoadOptions)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromNv21(@NotNull byte[] nv21, int width, int height, @NotNull RawImageLoadOptions options) {
            void var4_4;
            void var3_3;
            void var2_2;
            return ImageRef.fromNv21(nv21, (int)var2_2, (int)var3_3, (RawImageLoadOptions)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef deserialize(@NotNull String source) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
            UUID uUID = UUID.fromString((String)v0);
            Intrinsics.checkNotNull((Object)uUID);
            return this.fromSerializedReference(uUID);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromSerializedReference(@NotNull UUID uniqueId) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            ImageRef imageRef = new ImageRef((UUID)var1_1, false);
            imageRef.upgradeSerializedReference();
            return imageRef;
        }

        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull Map<String, ? extends Object> source) {
            Map<String, ? extends Object> map = source;
            Intrinsics.checkNotNullParameter(map, (String)"source");
            if (map.containsKey("buffer")) {
                Object object = MapsKt.getValue((Map)var1_1, (Object)"buffer");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this = ((Companion)this).fromEncodedBuffer(ByteArrayJson.INSTANCE.fromBase64((String)object), new BufferImageLoadOptions(null, BufferLoadMode.LAZY, 1, null));
                Intrinsics.checkNotNull((Object)this);
            } else {
                Object object = MapsKt.getValue((Map)var1_1, (Object)"uniqueId");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this = ((Companion)this).deserialize((String)object);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ImageRef fromJson(@NotNull JSONObject source) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
            return this.fromJson(JsonKt.toMap((JSONObject)v0));
        }

        /*
         * WARNING - void declaration
         */
        public void write(@NotNull ImageRef $this$write, @NotNull Parcel parcel, int flags) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"parcel");
            parcel.writeString(var1_1.serialize());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public ImageRef create(@NotNull Parcel parcel) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"parcel");
            String string = v0.readString();
            Intrinsics.checkNotNull((Object)string);
            return this.deserialize(string);
        }

        @JvmStatic
        public final void setHibernationJpegQuality(int quality) {
            ImageRef.setHibernationJpegQuality(quality);
        }

        @JvmStatic
        public final void setHibernationCacheDirPath(@Nullable String cacheDirPath) {
            ImageRef.setHibernationCacheDirPath(cacheDirPath);
        }

        @JvmStatic
        public final void setStorageCryptingProvider(@Nullable CoreStreamProvider storageCryptingProvider) {
            ImageRef.setStorageCryptingProvider(storageCryptingProvider);
        }

        @JvmStatic
        public final boolean acquireSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.acquireSerializedReference(uniqueId);
        }

        @JvmStatic
        public final boolean releaseStrongReference(@NotNull UUID uniqueId) {
            return ImageRef.releaseStrongReference(uniqueId);
        }

        @JvmStatic
        public final boolean upgradeSerializedReference(@NotNull UUID uniqueId) {
            return ImageRef.upgradeSerializedReference(uniqueId);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public ImageRef[] newArray(int size) {
            void var1_1;
            return (ImageRef[])Parceler.DefaultImpls.newArray((Parceler)this, (int)var1_1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageSerializationMode.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[ImageSerializationMode.REFERENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[ImageSerializationMode.BUFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

