/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class AdaptiveMap {
    private static final int NORM_REDUCTION = 16;
    private static final int NORM_SIZE = 3;
    private static final int NORM_BG_VALUE = 200;

    public static Pix backgroundNormMorph(Pix pixs) {
        return AdaptiveMap.backgroundNormMorph(pixs, 16, 3, 200);
    }

    public static Pix backgroundNormMorph(Pix pixs, int normReduction, int normSize, int normBgValue) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int nativePix = AdaptiveMap.nativeBackgroundNormMorph(pixs.mNativePix, normReduction, normSize, normBgValue);
        if (nativePix == 0) {
            throw new RuntimeException("Failed to normalize image background");
        }
        return new Pix(nativePix);
    }

    private static native int nativeBackgroundNormMorph(int var0, int var1, int var2, int var3);

    static {
        System.loadLibrary("lept");
    }
}

