/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Binarize {
    public static final int OTSU_SIZE_X = 32;
    public static final int OTSU_SIZE_Y = 32;
    public static final int OTSU_SMOOTH_X = 2;
    public static final int OTSU_SMOOTH_Y = 2;
    public static final float OTSU_SCORE_FRACTION = 0.1f;

    public static Pix otsuAdaptiveThreshold(Pix pixs) {
        return Binarize.otsuAdaptiveThreshold(pixs, 32, 32, 2, 2, 0.1f);
    }

    public static Pix otsuAdaptiveThreshold(Pix pixs, int sizeX, int sizeY, int smoothX, int smoothY, float scoreFraction) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixs.getDepth() != 8) {
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        int nativePix = Binarize.nativeOtsuAdaptiveThreshold(pixs.mNativePix, sizeX, sizeY, smoothX, smoothY, scoreFraction);
        if (nativePix == 0) {
            throw new RuntimeException("Failed to perform Otsu adaptive threshold on image");
        }
        return new Pix(nativePix);
    }

    public static Pix sauvolaBinarizeTiled(Pix pixs, int whsize, float factor, int nx, int ny) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixs.getDepth() != 8) {
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        int nativePix = Binarize.nativeSauvolaBinarizeTiled(pixs.mNativePix, whsize, factor, nx, ny);
        if (nativePix == 0) {
            throw new RuntimeException("Failed to perform Otsu adaptive threshold on image");
        }
        return new Pix(nativePix);
    }

    private static native int nativeOtsuAdaptiveThreshold(int var0, int var1, int var2, int var3, int var4, float var5);

    private static native int nativeSauvolaBinarizeTiled(int var0, int var1, float var2, int var3, int var4);

    static {
        System.loadLibrary("lept");
    }
}

