/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

public class Box {
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    public static final int INDEX_W = 2;
    public static final int INDEX_H = 3;
    final int mNativeBox;
    private boolean mRecycled = false;

    Box(int nativeBox) {
        this.mNativeBox = nativeBox;
        this.mRecycled = false;
    }

    public Box(int x, int y, int w, int h) {
        if (x < 0 || y < 0 || w < 0 || h < 0) {
            throw new IllegalArgumentException("All box dimensions must be non-negative");
        }
        int nativeBox = Box.nativeCreate(x, y, w, h);
        if (nativeBox == 0) {
            throw new OutOfMemoryError();
        }
        this.mNativeBox = nativeBox;
        this.mRecycled = false;
    }

    public int getX() {
        return Box.nativeGetX(this.mNativeBox);
    }

    public int getY() {
        return Box.nativeGetY(this.mNativeBox);
    }

    public int getWidth() {
        return Box.nativeGetWidth(this.mNativeBox);
    }

    public int getHeight() {
        return Box.nativeGetHeight(this.mNativeBox);
    }

    public int[] getGeometry() {
        int[] geometry = new int[4];
        if (this.getGeometry(geometry)) {
            return geometry;
        }
        return null;
    }

    public boolean getGeometry(int[] geometry) {
        if (geometry.length < 4) {
            throw new IllegalArgumentException("Geometry array must be at least 4 elements long");
        }
        return Box.nativeGetGeometry(this.mNativeBox, geometry);
    }

    public void recycle() {
        if (!this.mRecycled) {
            Box.nativeDestroy(this.mNativeBox);
            this.mRecycled = true;
        }
    }

    protected void finalize() throws Throwable {
        this.recycle();
        super.finalize();
    }

    private static native int nativeCreate(int var0, int var1, int var2, int var3);

    private static native int nativeGetX(int var0);

    private static native int nativeGetY(int var0);

    private static native int nativeGetWidth(int var0);

    private static native int nativeGetHeight(int var0);

    private static native void nativeDestroy(int var0);

    private static native boolean nativeGetGeometry(int var0, int[] var1);

    static {
        System.loadLibrary("lept");
    }
}

