/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;

public class Pix {
    public static final int INDEX_W = 0;
    public static final int INDEX_H = 1;
    public static final int INDEX_D = 2;
    final int mNativePix;
    private boolean mRecycled;

    public Pix(int nativePix) {
        this.mNativePix = nativePix;
        this.mRecycled = false;
    }

    public Pix(int width, int height, int depth) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Pix width and height must be > 0");
        }
        if (depth != 1 && depth != 2 && depth != 4 && depth != 8 && depth != 16 && depth != 24 && depth != 32) {
            throw new IllegalArgumentException("Depth must be one of 1, 2, 4, 8, 16, or 32");
        }
        this.mNativePix = Pix.nativeCreatePix(width, height, depth);
        this.mRecycled = false;
    }

    public int getNativePix() {
        return this.mNativePix;
    }

    public byte[] getData() {
        int size = Pix.nativeGetDataSize(this.mNativePix);
        byte[] buffer = new byte[size];
        if (!Pix.nativeGetData(this.mNativePix, buffer)) {
            throw new RuntimeException("native getData failed");
        }
        return buffer;
    }

    public int[] getDimensions() {
        int[] dimensions = new int[4];
        if (this.getDimensions(dimensions)) {
            return dimensions;
        }
        return null;
    }

    public boolean getDimensions(int[] dimensions) {
        return Pix.nativeGetDimensions(this.mNativePix, dimensions);
    }

    public Pix clone() {
        int nativePix = Pix.nativeClone(this.mNativePix);
        if (nativePix == 0) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public Pix copy() {
        int nativePix = Pix.nativeCopy(this.mNativePix);
        if (nativePix == 0) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public boolean invert() {
        return Pix.nativeInvert(this.mNativePix);
    }

    public void recycle() {
        if (!this.mRecycled) {
            Pix.nativeDestroy(this.mNativePix);
            this.mRecycled = true;
        }
    }

    protected void finalize() throws Throwable {
        this.recycle();
        super.finalize();
    }

    public static Pix createFromPix(byte[] pixData, int width, int height, int depth) {
        int nativePix = Pix.nativeCreateFromData(pixData, width, height, depth);
        if (nativePix == 0) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public Rect getRect() {
        int w = this.getWidth();
        int h = this.getHeight();
        return new Rect(0, 0, w, h);
    }

    public int getWidth() {
        return Pix.nativeGetWidth(this.mNativePix);
    }

    public int getHeight() {
        return Pix.nativeGetHeight(this.mNativePix);
    }

    public int getDepth() {
        return Pix.nativeGetDepth(this.mNativePix);
    }

    public int getPixel(int x, int y) {
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        return Pix.nativeGetPixel(this.mNativePix, x, y);
    }

    public void setPixel(int x, int y, int color) {
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        Pix.nativeSetPixel(this.mNativePix, x, y, color);
    }

    private static native int nativeCreatePix(int var0, int var1, int var2);

    private static native int nativeCreateFromData(byte[] var0, int var1, int var2, int var3);

    private static native boolean nativeGetData(int var0, byte[] var1);

    private static native int nativeGetDataSize(int var0);

    private static native int nativeClone(int var0);

    private static native int nativeCopy(int var0);

    private static native boolean nativeInvert(int var0);

    private static native void nativeDestroy(int var0);

    private static native boolean nativeGetDimensions(int var0, int[] var1);

    private static native int nativeGetWidth(int var0);

    private static native int nativeGetHeight(int var0);

    private static native int nativeGetDepth(int var0);

    private static native int nativeGetPixel(int var0, int var1, int var2);

    private static native void nativeSetPixel(int var0, int var1, int var2, int var3);

    static {
        System.loadLibrary("lept");
    }
}

