/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import com.googlecode.leptonica.android.Box;
import com.googlecode.leptonica.android.Pix;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pixa
implements Iterable<Pix> {
    final long mNativePixa;
    final int mWidth;
    final int mHeight;
    private boolean mRecycled;

    public static Pixa createPixa(int size) {
        return Pixa.createPixa(size, 0, 0);
    }

    public static Pixa createPixa(int size, int width, int height) {
        long nativePixa = Pixa.nativeCreate(size);
        if (nativePixa == 0L) {
            throw new OutOfMemoryError();
        }
        return new Pixa(nativePixa, width, height);
    }

    public Pixa(long nativePixa, int width, int height) {
        this.mNativePixa = nativePixa;
        this.mWidth = width;
        this.mHeight = height;
        this.mRecycled = false;
    }

    public long getNativePixa() {
        return this.mNativePixa;
    }

    public Pixa copy() {
        int nativePixa = Pixa.nativeCopy(this.mNativePixa);
        if (nativePixa == 0) {
            throw new OutOfMemoryError();
        }
        return new Pixa(nativePixa, this.mWidth, this.mHeight);
    }

    public Pixa sort(int field, int order) {
        int nativePixa = Pixa.nativeSort(this.mNativePixa, field, order);
        if (nativePixa == 0) {
            throw new OutOfMemoryError();
        }
        return new Pixa(nativePixa, this.mWidth, this.mHeight);
    }

    public int size() {
        return Pixa.nativeGetCount(this.mNativePixa);
    }

    public synchronized void recycle() {
        if (!this.mRecycled) {
            Pixa.nativeDestroy(this.mNativePixa);
            this.mRecycled = true;
        }
    }

    protected void finalize() throws Throwable {
        this.recycle();
        super.finalize();
    }

    public boolean join(Pixa otherPixa) {
        return Pixa.nativeJoin(this.mNativePixa, otherPixa.mNativePixa);
    }

    public void addPix(Pix pix, int mode) {
        Pixa.nativeAddPix(this.mNativePixa, pix.mNativePix, mode);
    }

    public void addBox(Box box, int mode) {
        Pixa.nativeAddBox(this.mNativePixa, box.mNativeBox, mode);
    }

    public void add(Pix pix, Box box, int mode) {
        Pixa.nativeAdd(this.mNativePixa, pix.mNativePix, box.mNativeBox, mode);
    }

    public Box getBox(int index) {
        long nativeBox = Pixa.nativeGetBox(this.mNativePixa, index);
        if (nativeBox == 0L) {
            return null;
        }
        return new Box(nativeBox);
    }

    public Pix getPix(int index) {
        int nativePix = Pixa.nativeGetPix(this.mNativePixa, index);
        if (nativePix == 0) {
            return null;
        }
        return new Pix(nativePix);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Rect getRect() {
        return new Rect(0, 0, this.mWidth, this.mHeight);
    }

    public Rect getBoxRect(int index) {
        int[] dimensions = this.getBoxGeometry(index);
        if (dimensions == null) {
            return null;
        }
        int x = dimensions[0];
        int y = dimensions[1];
        int w = dimensions[2];
        int h = dimensions[3];
        Rect bound = new Rect(x, y, x + w, y + h);
        return bound;
    }

    public int[] getBoxGeometry(int index) {
        int[] dimensions = new int[4];
        if (this.getBoxGeometry(index, dimensions)) {
            return dimensions;
        }
        return null;
    }

    public boolean getBoxGeometry(int index, int[] dimensions) {
        return Pixa.nativeGetBoxGeometry(this.mNativePixa, index, dimensions);
    }

    public ArrayList<Rect> getBoxRects() {
        int pixaCount = Pixa.nativeGetCount(this.mNativePixa);
        int[] buffer = new int[4];
        ArrayList<Rect> rects = new ArrayList<Rect>(pixaCount);
        for (int i = 0; i < pixaCount; ++i) {
            this.getBoxGeometry(i, buffer);
            int x = buffer[0];
            int y = buffer[1];
            Rect bound = new Rect(x, y, x + buffer[2], y + buffer[3]);
            rects.add(bound);
        }
        return rects;
    }

    public void replacePix(int index, Pix pix, Box box) {
        Pixa.nativeReplacePix(this.mNativePixa, index, pix.mNativePix, box.mNativeBox);
    }

    public void mergeAndReplacePix(int indexA, int indexB) {
        Pixa.nativeMergeAndReplacePix(this.mNativePixa, indexA, indexB);
    }

    public boolean writeToFileRandomCmap(File file) {
        return Pixa.nativeWriteToFileRandomCmap(this.mNativePixa, file.getAbsolutePath(), this.mWidth, this.mHeight);
    }

    @Override
    public Iterator<Pix> iterator() {
        return new PixIterator();
    }

    private static native int nativeCreate(int var0);

    private static native int nativeCopy(long var0);

    private static native int nativeSort(long var0, int var2, int var3);

    private static native boolean nativeJoin(long var0, long var2);

    private static native int nativeGetCount(long var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeAddPix(long var0, long var2, int var4);

    private static native void nativeAddBox(long var0, long var2, int var4);

    private static native void nativeAdd(long var0, long var2, long var4, int var6);

    private static native boolean nativeWriteToFileRandomCmap(long var0, String var2, int var3, int var4);

    private static native void nativeReplacePix(long var0, int var2, long var3, long var5);

    private static native void nativeMergeAndReplacePix(long var0, int var2, int var3);

    private static native long nativeGetBox(long var0, int var2);

    private static native int nativeGetPix(long var0, int var2);

    private static native boolean nativeGetBoxGeometry(long var0, int var2, int[] var3);

    static {
        System.loadLibrary("lept");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PixIterator
    implements Iterator<Pix> {
        private int mIndex = 0;

        private PixIterator() {
        }

        @Override
        public boolean hasNext() {
            int size = Pixa.this.size();
            return size > 0 && this.mIndex < size;
        }

        @Override
        public Pix next() {
            return Pixa.this.getPix(this.mIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

