/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class GrayQuant {
    public static Pix pixThresholdToBinary(Pix pixs, int thresh) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int depth = pixs.getDepth();
        if (depth != 4 && depth != 8) {
            throw new IllegalArgumentException("Source pix depth must be 4 or 8 bpp");
        }
        if (depth == 4 && thresh > 16) {
            throw new IllegalArgumentException("4 bpp thresh not in {0-16}");
        }
        if (depth == 8 && thresh > 256) {
            throw new IllegalArgumentException("8 bpp thresh not in {0-256}");
        }
        long nativePix = GrayQuant.nativePixThresholdToBinary(pixs.getNativePix(), thresh);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to perform binarization");
        }
        return new Pix(nativePix);
    }

    private static native long nativePixThresholdToBinary(long var0, int var2);

    static {
        System.loadLibrary("lept");
    }
}

