/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    private static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int start = (name = name.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (start == -1) {
            start = name.lastIndexOf(46);
        }
        return name.substring(start + 1);
    }

    public static final class ToStringHelper {
        private final String className;
        private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();
        private boolean omitNullValues = false;

        private ToStringHelper(String className) {
            this.className = Preconditions.checkNotNull(className);
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            Preconditions.checkNotNull(name);
            this.addHolder((Object)value).builder.append(name).append('=').append(value);
            return this;
        }

        public ToStringHelper add(String name, boolean value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, int value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, long value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        private StringBuilder checkNameAndAppend(String name) {
            Preconditions.checkNotNull(name);
            return this.addHolder().builder.append(name).append('=');
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.addHolder((Object)value).builder.append(value);
            return this;
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean needsSeparator = false;
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            for (ValueHolder valueHolder : this.valueHolders) {
                if (omitNullValuesSnapshot && valueHolder.isNull) continue;
                if (needsSeparator) {
                    builder.append(", ");
                } else {
                    needsSeparator = true;
                }
                StringBuilder sequence = valueHolder.builder;
                builder.append((CharSequence)sequence);
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder = new ValueHolder();
            this.valueHolders.add(valueHolder);
            return valueHolder;
        }

        private ValueHolder addHolder(@Nullable Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.isNull = value == null;
            return valueHolder;
        }

        private static final class ValueHolder {
            final StringBuilder builder = new StringBuilder();
            boolean isNull;

            private ValueHolder() {
            }
        }
    }
}

