/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.language;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.base.Objects;
import java.io.IOException;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.preprocessing.StringFilter;

public class MarkovConfiguration {
    @Parameter(names={"-k"}, description="Length of n-grams to use.")
    private int k = 6;
    @Parameter(names={"-size"}, description="Number of best tokens to keep when learning")
    private int size = 1000;
    @ParametersDelegate
    private StringFilter filter = new StringFilter();

    public int getK() {
        return this.k;
    }

    public StringFilter getFilter() {
        return this.filter;
    }

    public MarkovConfiguration fromChunk(BinaryChunk bc) throws IOException {
        StringFilter f = new StringFilter().fromChunk(bc);
        BinaryChunk m = bc.readChunk("mrkv");
        this.k = m.readI32();
        this.size = m.readI32();
        return this;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.filter).add("k", this.k).add("size", this.size).toString();
    }
}

