/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.AbstractIterator;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;

abstract class Splitter$SplittingIterator
extends AbstractIterator<String> {
    final CharSequence toSplit;
    final CharMatcher trimmer;
    final boolean omitEmptyStrings;
    int offset = 0;
    int limit;

    abstract int separatorStart(int var1);

    abstract int separatorEnd(int var1);

    protected Splitter$SplittingIterator(Splitter splitter, CharSequence toSplit) {
        this.trimmer = Splitter.access$200(splitter);
        this.omitEmptyStrings = Splitter.access$300(splitter);
        this.limit = Splitter.access$400(splitter);
        this.toSplit = toSplit;
    }

    @Override
    protected String computeNext() {
        int nextStart = this.offset;
        while (this.offset != -1) {
            int end;
            int start = nextStart;
            int separatorPosition = this.separatorStart(this.offset);
            if (separatorPosition == -1) {
                end = this.toSplit.length();
                this.offset = -1;
            } else {
                end = separatorPosition;
                this.offset = this.separatorEnd(separatorPosition);
            }
            if (this.offset == nextStart) {
                ++this.offset;
                if (this.offset < this.toSplit.length()) continue;
                this.offset = -1;
                continue;
            }
            while (start < end && this.trimmer.matches(this.toSplit.charAt(start))) {
                ++start;
            }
            while (end > start && this.trimmer.matches(this.toSplit.charAt(end - 1))) {
                --end;
            }
            if (this.omitEmptyStrings && start == end) {
                nextStart = this.offset;
                continue;
            }
            if (this.limit == 1) {
                this.offset = -1;
                for (end = this.toSplit.length(); end > start && this.trimmer.matches(this.toSplit.charAt(end - 1)); --end) {
                }
            } else {
                --this.limit;
            }
            return ((Object)this.toSplit.subSequence(start, end)).toString();
        }
        return (String)this.endOfData();
    }
}

