/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.natalie;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import net.doo.datamining.natalie.BinaryDmnbClassifier;
import net.doo.datamining.preprocessing.BagOfWords;
import net.doo.datamining.preprocessing.Dictionary;
import net.doo.datamining.util.Pair;

public class NatalieLearningResult {
    public final Dictionary dictionary;
    public final ImmutableSortedMap<Pair<String, String>, BinaryDmnbClassifier> classifiers;

    public NatalieLearningResult(Dictionary dictionary, ImmutableSortedMap<Pair<String, String>, BinaryDmnbClassifier> classifiers) {
        this.dictionary = dictionary;
        this.classifiers = classifiers;
    }

    public NatalieLearningResult() {
        this.dictionary = new Dictionary(ImmutableSet.<String>of(), ImmutableList.<BagOfWords>of());
        this.classifiers = ImmutableSortedMap.of();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Natalie learned ").append(this.classifiers.size()).append(" classifiers:\n");
        for (BinaryDmnbClassifier nc : this.classifiers.values()) {
            builder.append((String)nc.categoryKey.fst).append(" ").append((String)nc.categoryKey.snd).append("\n");
        }
        builder.append("Using a dictionary of size: ").append(this.dictionary.getIndexedWords().size()).append("\n");
        return builder.toString();
    }
}

