/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.Serializable;
import net.doo.datamining.util.Tuple;

public class Pair<F extends Comparable<F>, S extends Comparable<S>>
extends Tuple<F, S>
implements Serializable,
Comparable<Pair<F, S>> {
    protected Pair(F fst, S snd) {
        super(fst, snd);
    }

    public static <F extends Comparable<F>, S extends Comparable<S>> Pair<F, S> of(F fst, S snd) {
        return new Pair<F, S>(fst, snd);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.fst == null ? other.fst != null : !((Comparable)this.fst).equals(other.fst)) {
            return false;
        }
        return !(this.snd == null ? other.snd != null : !((Comparable)this.snd).equals(other.snd));
    }

    private static <X extends Comparable<X>> int cmp(X a, X b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(Pair<F, S> that) {
        int c1 = Pair.cmp((Comparable)this.fst, (Comparable)that.fst);
        if (c1 != 0) {
            return c1;
        }
        return Pair.cmp((Comparable)this.snd, (Comparable)that.snd);
    }
}

