/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.language;

import java.io.IOException;
import net.doo.datamining.NGrams;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.language.MarkovConfiguration;
import net.doo.datamining.util.HashMapDouble;
import net.doo.datamining.util.Iso15924;
import net.doo.datamining.util.UnicodeScript;
import org.apache.log4j.Logger;

public class MarkovClassifier {
    private static final Logger log = Logger.getLogger(MarkovClassifier.class);
    private String isoCode;
    private long sampleLength;
    private HashMapDouble<String> probabilities;
    public final MarkovConfiguration markovConfiguration;

    public String getIsoCode() {
        return this.isoCode;
    }

    public MarkovClassifier(MarkovConfiguration markovConfiguration) {
        this.markovConfiguration = markovConfiguration;
    }

    public MarkovClassifier fromChunk(BinaryChunk parent) throws IOException {
        BinaryChunk b = parent.readChunk("cfmv");
        this.isoCode = b.readString();
        this.sampleLength = b.readI64();
        int probabilitiesSize = b.readI32();
        this.probabilities = new HashMapDouble(probabilitiesSize * 2, Math.log(1.0 / (double)this.sampleLength));
        for (int n = 0; n < probabilitiesSize; ++n) {
            String ngram = b.readString();
            double probability = b.readDouble();
            this.probabilities.put(ngram, probability);
        }
        return this;
    }

    public double classifyFiltered(String filtered) {
        double score = 0.0;
        double runningScore = 0.0;
        int count = 0;
        StringBuilder info = new StringBuilder();
        StringBuilder text = new StringBuilder();
        int k = UnicodeScript.getNGramLength((Iso15924)UnicodeScript.langToScript.get((Object)this.isoCode));
        for (String ngram : new NGrams<String>(k, filtered)) {
            if (++count % 80 == 0 && log.isTraceEnabled()) {
                log.trace((Object)info.toString());
                info.setLength(0);
                log.trace((Object)text.toString());
                text.setLength(0);
            }
            double nGramScore = this.probabilities.get(ngram);
            score += nGramScore;
            runningScore += nGramScore;
            if (!log.isTraceEnabled()) continue;
            if (count % 20 == 0) {
                info.append(String.format(" %8d %8d |", (int)runningScore, (int)score));
                runningScore = 0.0;
            }
            if (!this.probabilities.containsKey(ngram)) continue;
            text.append(ngram).append(' ');
        }
        double max = Math.log(0.5) * (double)filtered.length();
        double min = this.probabilities.defaultValue() * (double)filtered.length();
        double result = (score - min) / (max - min);
        log.debug((Object)String.format("================================================================================================ \n|%s: k %1d, max %5.4f, min %5.4f, raw %5.4f, default %5.4f, result %8.7f|\n================================================================================================", this.isoCode, k, max, min, score, this.probabilities.defaultValue(), result));
        return result;
    }
}

