/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.natalie;

import java.io.IOException;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.io.IO;
import net.doo.datamining.natalie.Counter;
import net.doo.datamining.preprocessing.WordVector;
import net.doo.datamining.util.Pair;

public class BinaryDmnbClassifier {
    public final Counter inClassCounter;
    public final Counter notInClassCounter;
    final double[] wordCoefficients;
    public final Pair<String, String> categoryKey;
    public double minConfidence;
    double dPrior = 0.0;
    double wNormalizer = 0.0;

    public BinaryDmnbClassifier(Pair<String, String> classKey, int dictionarySize, int laplaceDefault, double minConfidence) {
        this.categoryKey = classKey;
        this.inClassCounter = new Counter(dictionarySize, laplaceDefault);
        this.notInClassCounter = new Counter(dictionarySize, laplaceDefault);
        this.minConfidence = minConfidence;
        this.wordCoefficients = new double[dictionarySize];
    }

    public double getScore(WordVector wordVector, boolean documentPrior) {
        double score = 0.0;
        if (documentPrior) {
            score = this.dPrior;
        }
        for (int n = 0; n < wordVector.indices.length; ++n) {
            double c = this.wordCoefficients[wordVector.indices[n]];
            score += c * wordVector.values[n];
            score -= this.wNormalizer;
        }
        return score;
    }

    public static BinaryDmnbClassifier fromChunk(BinaryChunk b, int laplaceDefault) throws IOException {
        BinaryChunk c = b.readChunk("cfnt");
        double dPrior = c.readDouble();
        double wNormalizer = c.readDouble();
        double minConfidence = c.readDouble();
        String categoryName = IO.mapCategoryNameIncoming(c.readString());
        String subCategoryName = c.readString();
        int coefficientLength = c.readI32();
        BinaryDmnbClassifier classifier = new BinaryDmnbClassifier(Pair.of(categoryName, subCategoryName), coefficientLength, laplaceDefault, minConfidence);
        classifier.dPrior = dPrior;
        classifier.wNormalizer = wNormalizer;
        for (int n = 0; n < coefficientLength; ++n) {
            classifier.wordCoefficients[n] = c.readDouble();
        }
        return classifier;
    }
}

