/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCommander {
    private Map<String, ParameterDescription> m_descriptions;
    private List<Object> m_objects = Lists.newArrayList();
    private Parameterized m_mainParameter = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private ParameterDescription m_mainParameterDescription;
    private Map<Parameterized, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Parameterized, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;
    private IDefaultProvider m_defaultProvider;
    private Map<ProgramName, JCommander> m_commands = Maps.newLinkedHashMap();
    private Map<String, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String m_parsedCommand;
    private String m_parsedAlias;
    private ProgramName m_programName;
    private Comparator<? super ParameterDescription> m_parameterDescriptionComparator = new Comparator<ParameterDescription>(){

        @Override
        public int compare(ParameterDescription p0, ParameterDescription p1) {
            return p0.getLongestName().compareTo(p1.getLongestName());
        }
    };
    private int m_columnSize = 79;
    private boolean m_helpWasSpecified;
    private static Console m_console;
    private static LinkedList<IStringConverterFactory> CONVERTER_FACTORIES;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();
    private int m_verbose = 0;

    public JCommander() {
    }

    public JCommander(Object object) {
        this.addObject(object);
        this.createDescriptions();
    }

    public JCommander(Object object, String ... args) {
        this.addObject(object);
        this.parse(args);
    }

    public static Console getConsole() {
        if (m_console == null) {
            try {
                Method method = System.class.getDeclaredMethod("console", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                m_console = new JDK6Console(object);
            }
            catch (Throwable throwable) {
                m_console = new DefaultConsole();
            }
        }
        return m_console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            for (Object o : (Object[])object) {
                this.m_objects.add(o);
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public void parse(String ... args) {
        this.parse(true, args);
    }

    private void parse(boolean validate, String ... args) {
        StringBuilder sb = new StringBuilder("Parsing \"");
        sb.append((CharSequence)this.join(args).append("\"\n  with:").append((CharSequence)this.join(this.m_objects.toArray())));
        this.p(sb.toString());
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args));
        if (validate) {
            this.validateOptions();
        }
    }

    private StringBuilder join(Object[] args) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(args[i]);
        }
        return result;
    }

    private void initializeDefaultValues() {
        if (this.m_defaultProvider != null) {
            for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
                this.initializeDefaultValue(parameterDescription);
            }
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.m_helpWasSpecified) {
            return;
        }
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()).append(" ");
            }
            throw new ParameterException("The following " + JCommander.pluralize(this.m_requiredFields.size(), "option is required: ", "options are required: ") + missingFields);
        }
        if (this.m_mainParameterDescription != null && this.m_mainParameterDescription.getParameter().required() && !this.m_mainParameterDescription.isAssigned()) {
            throw new ParameterException("Main parameters are required (\"" + this.m_mainParameterDescription.getDescription() + "\")");
        }
    }

    private static String pluralize(int quantity, String singular, String plural) {
        return quantity == 1 ? singular : plural;
    }

    private String[] expandArgs(String[] originalArgv) {
        List vResult1 = Lists.newArrayList();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult1.addAll(JCommander.readFile(fileName));
                continue;
            }
            List<String> expanded = this.expandDynamicArg(arg);
            vResult1.addAll(expanded);
        }
        List vResult2 = Lists.newArrayList();
        for (int i = 0; i < vResult1.size(); ++i) {
            String arg = (String)vResult1.get(i);
            String[] v1 = vResult1.toArray(new String[0]);
            if (this.isOption(v1, arg)) {
                String sep = this.getSeparatorFor(v1, arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    for (String ssp : sp = arg.split("[" + sep + "]", 2)) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private List<String> expandDynamicArg(String arg) {
        for (ParameterDescription pd : this.m_descriptions.values()) {
            if (!pd.isDynamicParameter()) continue;
            for (String name : pd.getParameter().names()) {
                if (!arg.startsWith(name) || arg.equals(name)) continue;
                return Arrays.asList(name, arg.substring(name.length()));
            }
        }
        return Arrays.asList(arg);
    }

    private boolean isOption(String[] args, String arg) {
        String prefixes = this.getOptionPrefixes(args, arg);
        return arg.length() > 0 && prefixes.indexOf(arg.charAt(0)) >= 0;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<String, ParameterDescription> es : this.m_descriptions.entrySet()) {
            if (!arg.startsWith(es.getKey())) continue;
            return es.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String[] args, String arg) {
        ParameterDescription result = this.getPrefixDescriptionFor(arg);
        if (result != null) {
            return result;
        }
        for (String a : args) {
            ParameterDescription pd = this.getPrefixDescriptionFor(arg);
            if (pd != null) {
                result = pd;
            }
            if (!a.equals(arg)) continue;
            return result;
        }
        throw new ParameterException("Unknown parameter: " + arg);
    }

    private String getSeparatorFor(String[] stringArray, String string) {
        Parameters parameters;
        ParameterDescription parameterDescription = this.getDescriptionFor(stringArray, string);
        if (parameterDescription != null && (parameters = parameterDescription.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return parameters.separators();
        }
        return " ";
    }

    private String getOptionPrefixes(String[] stringArray, String string) {
        Object object;
        ParameterDescription parameterDescription = this.getDescriptionFor(stringArray, string);
        if (parameterDescription != null && (object = parameterDescription.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return object.optionPrefixes();
        }
        object = "-";
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : this.m_objects) {
            Parameters parameters = object2.getClass().getAnnotation(Parameters.class);
            if (parameters == null || "-".equals(parameters.optionPrefixes())) continue;
            stringBuilder.append(parameters.optionPrefixes());
        }
        if (!Strings.isStringEmpty(stringBuilder.toString())) {
            object = stringBuilder.toString();
        }
        return object;
    }

    private static List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                if (line.length() <= 0) continue;
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"") && result.endsWith("\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        List<Parameterized> parameterizeds = Parameterized.parseArg(object);
        for (Parameterized parameterized : parameterizeds) {
            WrappedParameter wp = parameterized.getWrappedParameter();
            if (wp != null && wp.getParameter() != null) {
                Parameter annotation = wp.getParameter();
                Parameter p = annotation;
                if (p.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.m_mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameter + " and " + parameterized);
                    }
                    this.m_mainParameter = parameterized;
                    this.m_mainParameterObject = object;
                    this.m_mainParameterAnnotation = p;
                    this.m_mainParameterDescription = new ParameterDescription(object, p, parameterized, this.m_bundle, this);
                    continue;
                }
                for (String name : p.names()) {
                    if (this.m_descriptions.containsKey(name)) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    ParameterDescription pd = new ParameterDescription(object, p, parameterized, this.m_bundle, this);
                    this.m_fields.put(parameterized, pd);
                    this.m_descriptions.put(name, pd);
                    if (!p.required()) continue;
                    this.m_requiredFields.put(parameterized, pd);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                Object delegateObject = parameterized.get(object);
                if (delegateObject == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(delegateObject);
                continue;
            }
            if (wp == null || wp.getDynamicParameter() == null) continue;
            DynamicParameter dp = wp.getDynamicParameter();
            for (String name : dp.names()) {
                if (this.m_descriptions.containsKey(name)) {
                    throw new ParameterException("Found the option " + name + " multiple times");
                }
                this.p("Adding description for " + name);
                ParameterDescription pd = new ParameterDescription(object, dp, parameterized, this.m_bundle, this);
                this.m_fields.put(parameterized, pd);
                this.m_descriptions.put(name, pd);
                if (!dp.required()) continue;
                this.m_requiredFields.put(parameterized, pd);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription pd) {
        for (String optionName : pd.getParameter().names()) {
            String def = this.m_defaultProvider.getDefaultValueFor(optionName);
            if (def == null) continue;
            this.p("Initializing " + optionName + " with default value:" + def);
            pd.addValue(def, true);
            return;
        }
    }

    private void parseValues(String[] stringArray) {
        int n;
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; i += n) {
            Class<?> clazz;
            Object object;
            String string = stringArray[i];
            String object2 = JCommander.trim(string);
            this.p("Parsing arg: " + object2);
            JCommander jCommander = this.findCommandByAlias(string);
            n = 1;
            if (this.isOption(stringArray, object2) && jCommander == null) {
                object = this.m_descriptions.get(object2);
                if (object != null) {
                    if (((ParameterDescription)object).getParameter().password()) {
                        clazz = (Class<?>)this.readPassword(((ParameterDescription)object).getDescription(), ((ParameterDescription)object).getParameter().echoInput());
                        ((ParameterDescription)object).addValue(new String((char[])clazz));
                        this.m_requiredFields.remove(((ParameterDescription)object).getParameterized());
                        continue;
                    }
                    if (((ParameterDescription)object).getParameter().variableArity()) {
                        n = this.processVariableArity(stringArray, i, (ParameterDescription)object);
                        continue;
                    }
                    clazz = ((ParameterDescription)object).getParameterized().getType();
                    if ((clazz == Boolean.TYPE || clazz == Boolean.class) && ((ParameterDescription)object).getParameter().arity() == -1) {
                        ((ParameterDescription)object).addValue("true");
                        this.m_requiredFields.remove(((ParameterDescription)object).getParameterized());
                    } else {
                        n = this.processFixedArity(stringArray, i, (ParameterDescription)object, clazz);
                    }
                    if (!((ParameterDescription)object).isHelp()) continue;
                    this.m_helpWasSpecified = true;
                    continue;
                }
                throw new ParameterException("Unknown option: " + (String)string);
            }
            if (Strings.isStringEmpty(string)) continue;
            if (this.m_commands.isEmpty()) {
                ParameterizedType parameterizedType;
                Type type;
                object = this.getMainParameter(string);
                clazz = string;
                String string2 = clazz;
                if (this.m_mainParameter.getGenericType() instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)this.m_mainParameter.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    string2 = this.convertValue(this.m_mainParameter, (Class)type, (String)((Object)clazz));
                }
                ParameterDescription.validateParameter(this.m_mainParameterAnnotation.validateWith(), "Default", clazz);
                this.m_mainParameterDescription.setAssigned(true);
                object.add(string2);
                continue;
            }
            if (jCommander == null) {
                throw new MissingCommandException("Expected a command, got " + (String)string);
            }
            this.m_parsedCommand = jCommander.m_programName.m_name;
            this.m_parsedAlias = string;
            jCommander.parse(this.subArray(stringArray, i + 1));
            bl = true;
        }
        for (ParameterDescription parameterDescription : this.m_descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.m_fields.get(parameterDescription.getParameterized()).setAssigned(true);
        }
    }

    private int processVariableArity(String[] stringArray, int n, ParameterDescription parameterDescription) {
        int n2;
        Object object = parameterDescription.getObject();
        IVariableArity iVariableArity = !(object instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)object;
        List list = Lists.newArrayList();
        for (n2 = n + 1; n2 < stringArray.length; ++n2) {
            list.add(stringArray[n2]);
        }
        n2 = iVariableArity.processVariableArity(parameterDescription.getParameter().names()[0], list.toArray(new String[0]));
        int n3 = this.processFixedArity(stringArray, n, parameterDescription, List.class, n2);
        return n3;
    }

    private int processFixedArity(String[] args, int index, ParameterDescription pd, Class<?> fieldType) {
        int arity = pd.getParameter().arity();
        int n = arity != -1 ? arity : 1;
        return this.processFixedArity(args, index, pd, fieldType, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] stringArray, int n, ParameterDescription parameterDescription, Class<?> clazz, int n2) {
        int n3 = n;
        String string = stringArray[n3];
        if (n2 == 0 && (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz))) {
            parameterDescription.addValue("true");
            this.m_requiredFields.remove(parameterDescription.getParameterized());
            return n2 + 1;
        } else {
            int n4;
            if (n3 >= stringArray.length - 1) throw new ParameterException("Expected a value after parameter " + string);
            int n5 = n4 = "--".equals(stringArray[n3 + 1]) ? 1 : 0;
            if (n3 + n2 >= stringArray.length) throw new ParameterException("Expected " + n2 + " values after " + string);
            for (int i = 1; i <= n2; ++i) {
                parameterDescription.addValue(JCommander.trim(stringArray[n3 + i + n4]));
                this.m_requiredFields.remove(parameterDescription.getParameterized());
            }
            n3 += n2 + n4;
        }
        return n2 + 1;
    }

    private char[] readPassword(String description, boolean echoInput) {
        JCommander.getConsole().print(description + ": ");
        return JCommander.getConsole().readPassword(echoInput);
    }

    private String[] subArray(String[] args, int index) {
        int l = args.length - index;
        String[] result = new String[l];
        System.arraycopy(args, index, result, 0, l);
        return result;
    }

    private List<?> getMainParameter(String string) {
        if (this.m_mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + string + "' but no main parameter was defined");
        }
        List list = (List)this.m_mainParameter.get(this.m_mainParameterObject);
        if (list == null) {
            list = Lists.newArrayList();
            if (!List.class.isAssignableFrom(this.m_mainParameter.getType())) {
                throw new ParameterException("Main parameter field " + this.m_mainParameter + " needs to be of type List, not " + this.m_mainParameter.getType());
            }
            this.m_mainParameter.set(this.m_mainParameterObject, list);
        }
        return list;
    }

    public void usage(String commandName, StringBuilder out, String indent) {
        String description = this.getCommandDescription(commandName);
        JCommander jc = this.findCommandByAlias(commandName);
        if (description != null) {
            out.append(indent).append(description);
            out.append("\n");
        }
        jc.usage(out, indent);
    }

    public String getCommandDescription(String string) {
        JCommander jCommander = this.findCommandByAlias(string);
        if (jCommander == null) {
            throw new ParameterException("Asking description for unknown command: " + string);
        }
        Object object = jCommander.getObjects().get(0);
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (parameters != null) {
            string2 = parameters.commandDescription();
            String string3 = parameters.resourceBundle();
            resourceBundle = !"".equals(string3) ? ResourceBundle.getBundle(string3, Locale.getDefault()) : this.m_bundle;
            if (resourceBundle != null) {
                string2 = this.getI18nString(resourceBundle, parameters.commandDescriptionKey(), parameters.commandDescription());
            }
        }
        return string2;
    }

    private String getI18nString(ResourceBundle bundle, String key, String def) {
        String s = bundle != null ? bundle.getString(key) : null;
        return s != null ? s : def;
    }

    public void usage() {
        StringBuilder sb = new StringBuilder();
        this.usage(sb);
        JCommander.getConsole().println(sb.toString());
    }

    public void usage(StringBuilder out) {
        this.usage(out, "");
    }

    public void usage(StringBuilder stringBuilder, String string) {
        int n;
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        boolean bl = !this.m_commands.isEmpty();
        String string2 = this.m_programName != null ? this.m_programName.getDisplayName() : "<main class>";
        stringBuilder.append(string).append("Usage: " + string2 + " [options]");
        if (bl) {
            stringBuilder.append(string).append(" [command] [command options]");
        }
        if (this.m_mainParameterDescription != null) {
            stringBuilder.append(" " + this.m_mainParameterDescription.getDescription());
        }
        int n2 = 0;
        List<Object> list = Lists.newArrayList();
        for (ParameterDescription object : this.m_fields.values()) {
            if (object.getParameter().hidden()) continue;
            list.add(object);
            n = object.getNames().length() + 2;
            if (n <= n2) continue;
            n2 = n;
        }
        Collections.sort(list, this.getParameterDescriptionComparator());
        if (list.size() > 0) {
            stringBuilder.append(string).append("\n").append(string).append("  Options:\n");
        }
        for (ParameterDescription parameterDescription : list) {
            n = parameterDescription.getNames().length();
            int n3 = n2 - n;
            int n4 = stringBuilder.length();
            WrappedParameter wrappedParameter = parameterDescription.getParameter();
            stringBuilder.append(string).append("  " + (wrappedParameter.required() ? "* " : "  ") + parameterDescription.getNames() + this.s(n3));
            int n5 = stringBuilder.length() - n4;
            this.wrapDescription(stringBuilder, n5, parameterDescription.getDescription());
            Object object = parameterDescription.getDefault();
            if (parameterDescription.isDynamicParameter()) {
                stringBuilder.append("\n" + this.spaces(n5 + 1)).append("Syntax: " + wrappedParameter.names()[0] + "key" + wrappedParameter.getAssignment() + "value");
            }
            if (object != null) {
                String string3 = Strings.isStringEmpty(object.toString()) ? "<empty string>" : object.toString();
                stringBuilder.append("\n" + this.spaces(n5 + 1)).append("Default: " + (wrappedParameter.password() ? "********" : string3));
            }
            stringBuilder.append("\n");
        }
        if (bl) {
            stringBuilder.append("  Commands:\n");
            for (Map.Entry entry : this.m_commands.entrySet()) {
                ProgramName programName = (ProgramName)entry.getKey();
                String string4 = programName.getDisplayName();
                stringBuilder.append(string).append("    " + string4);
                this.usage(programName.getName(), stringBuilder, "      ");
                stringBuilder.append("\n");
            }
        }
    }

    private Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.m_parameterDescriptionComparator;
    }

    public int getColumnSize() {
        return this.m_columnSize;
    }

    private void wrapDescription(StringBuilder out, int indent, String description) {
        int max = this.getColumnSize();
        String[] words = description.split(" ");
        int current = indent;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                out.append(" ").append(word);
                current += word.length() + 1;
                continue;
            }
            out.append("\n").append(this.spaces(indent + 1)).append(word);
            current = indent;
        }
    }

    private String spaces(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void p(String string) {
        if (this.m_verbose > 0 || System.getProperty("jcommander.debug") != null) {
            JCommander.getConsole().println("[JCommander] " + string);
        }
    }

    public <T> Class<? extends IStringConverter<T>> findConverter(Class<T> cls) {
        for (IStringConverterFactory f : CONVERTER_FACTORIES) {
            Class<IStringConverter<T>> result = f.getConverter(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(ParameterDescription pd, String value) {
        return this.convertValue(pd.getParameterized(), pd.getParameterized().getType(), value);
    }

    public Object convertValue(Parameterized parameterized, Class clazz, String string) {
        Object object;
        block14: {
            Object object2;
            boolean bl;
            Parameter parameter = parameterized.getParameter();
            if (parameter == null) {
                return string;
            }
            Class clazz2 = parameter.converter();
            boolean bl2 = bl = parameter.listConverter() != NoConverter.class;
            if (clazz2 == null || clazz2 == NoConverter.class) {
                clazz2 = clazz.isEnum() ? clazz : this.findConverter(clazz);
            }
            if (clazz2 == null) {
                object2 = parameterized.findFieldGenericType();
                clazz2 = object2 != null ? this.findConverter((Class)object2) : StringConverter.class;
            }
            object = null;
            try {
                String string2;
                String[] stringArray = parameter.names();
                String string3 = string2 = stringArray.length > 0 ? stringArray[0] : "[Main class]";
                if (clazz2.isEnum()) {
                    try {
                        object = Enum.valueOf(clazz2, string.toUpperCase());
                        break block14;
                    }
                    catch (Exception exception) {
                        throw new ParameterException("Invalid value for " + string2 + " parameter. Allowed values:" + EnumSet.allOf(clazz2));
                    }
                }
                object2 = this.instantiateConverter(string2, clazz2);
                if (clazz.isAssignableFrom(List.class) && parameterized.getGenericType() instanceof ParameterizedType) {
                    if (bl) {
                        IStringConverter<?> iStringConverter = this.instantiateConverter(string2, parameter.listConverter());
                        object = iStringConverter.convert(string);
                    } else {
                        object = this.convertToList(string, (IStringConverter<?>)object2, parameter.splitter());
                    }
                } else {
                    object = object2.convert(string);
                }
            }
            catch (InstantiationException instantiationException) {
                throw new ParameterException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParameterException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ParameterException(invocationTargetException);
            }
        }
        return object;
    }

    private Object convertToList(String value, IStringConverter<?> converter, Class<? extends IParameterSplitter> splitterClass) throws InstantiationException, IllegalAccessException {
        IParameterSplitter splitter = splitterClass.newInstance();
        List result = Lists.newArrayList();
        for (String param : splitter.split(value)) {
            result.add(converter.convert(param));
        }
        return result;
    }

    private IStringConverter<?> instantiateConverter(String string, Class<? extends IStringConverter<?>> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray;
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        for (Constructor<?> constructor3 : constructorArray = clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor3.getParameterTypes();
            if (classArray.length == 1 && classArray[0].equals(String.class)) {
                constructor2 = constructor3;
                continue;
            }
            if (classArray.length != 0) continue;
            constructor = constructor3;
        }
        Constructor<?>[] constructorArray2 = constructor2 != null ? (IStringConverter)constructor2.newInstance(string) : (constructor != null ? (IStringConverter)constructor.newInstance(new Object[0]) : null);
        return constructorArray2;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.m_objects;
    }

    private JCommander findCommandByAlias(String string) {
        ProgramName programName = this.aliasMap.get(string);
        if (programName == null) {
            return null;
        }
        JCommander jCommander = this.m_commands.get(programName);
        if (jCommander == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jCommander;
    }

    static {
        CONVERTER_FACTORIES = Lists.newLinkedList();
        CONVERTER_FACTORIES.addFirst(new DefaultConverterFactory());
    }

    private static final class ProgramName {
        private final String m_name;
        private final List<String> m_aliases;

        public String getName() {
            return this.m_name;
        }

        private String getDisplayName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_name);
            if (!this.m_aliases.isEmpty()) {
                sb.append("(");
                Iterator<String> aliasesIt = this.m_aliases.iterator();
                while (aliasesIt.hasNext()) {
                    sb.append(aliasesIt.next());
                    if (!aliasesIt.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramName other = (ProgramName)obj;
            return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        public int processVariableArity(String optionName, String[] options) {
            int i;
            for (i = 0; i < options.length && !JCommander.this.isOption(options, options[i]); ++i) {
            }
            return i;
        }
    }
}

