/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.doo.datamining.util.Pair;

public class ConfusionMatrix {
    private final Collection<Entry> classificationResults = Lists.newArrayList();
    private final TreeMap<String, Double> minConfidences = Maps.newTreeMap();
    private int instances = 0;
    private int positiveInstances = 0;
    private int negativeInstances = 0;

    public ConfusionMatrix() {
        this.minConfidences.put("0", 0.0);
    }

    public double getMinConfidence(String category) {
        Double minConfidence = this.minConfidences.get(category);
        if (minConfidence == null) {
            return 0.0;
        }
        return minConfidence;
    }

    public void addResult(String actualClass, String detectedClass, String filename, double confidence) {
        this.classificationResults.add(new Entry(actualClass, detectedClass, filename, confidence));
        ++this.instances;
        if ("0".equals(actualClass)) {
            ++this.negativeInstances;
        } else {
            ++this.positiveInstances;
        }
        if (!this.minConfidences.containsKey(actualClass)) {
            this.minConfidences.put(actualClass, 0.0);
        }
        if (!this.minConfidences.containsKey(detectedClass)) {
            this.minConfidences.put(detectedClass, 0.0);
        }
    }

    public Collection<String> getCategories() {
        return Collections.unmodifiableSet(this.minConfidences.keySet());
    }

    public Collection<String> getPositiveCategories() {
        TreeSet<String> result = new TreeSet<String>(this.getCategories());
        result.remove("0");
        return result;
    }

    ArrayListMultimap<Pair<String, String>, Entry> calculateMatrix() {
        ArrayListMultimap<Pair<String, String>, Entry> result = ArrayListMultimap.create();
        for (Entry entry : this.classificationResults) {
            String resultingClass = entry.confidence >= this.getMinConfidence(entry.detectedClass) ? entry.detectedClass : "0";
            result.put(Pair.of(entry.actualClass, resultingClass), (Object)entry);
        }
        return result;
    }

    private int rowSum(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String originalCategory) {
        int sum = 0;
        for (String detectedCategory : this.getCategories()) {
            sum += matrixData.get((Object)Pair.of(originalCategory, detectedCategory)).size();
        }
        return sum;
    }

    public int columnSum(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String detectedCategory) {
        int sum = 0;
        for (String originalCategory : this.getCategories()) {
            sum += matrixData.get((Object)Pair.of(originalCategory, detectedCategory)).size();
        }
        return sum;
    }

    private double calculatePrecision(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String category) {
        double correct = matrixData.get((Object)Pair.of(category, category)).size();
        double total = this.columnSum(matrixData, category);
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    private double calculateRecall(ArrayListMultimap<Pair<String, String>, Entry> matrixData, String category) {
        double correct = matrixData.get((Object)Pair.of(category, category)).size();
        double total = this.rowSum(matrixData, category);
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public static double calculateFMeasure(double beta, double precision, double recall) {
        double betaSq = beta * beta;
        if (precision + recall == 0.0) {
            return 0.0;
        }
        return (1.0 + betaSq) * (precision * recall) / (betaSq * precision + recall);
    }

    public ConfusionMatrixResult calculateResult(double beta) {
        return new ConfusionMatrixResult(this, beta);
    }

    public static String int2str26(int num) {
        StringBuilder sb = new StringBuilder();
        int i = num;
        do {
            sb.append((char)(97 + i % 26));
        } while ((i = i / 26 - 1) >= 0);
        return sb.reverse().toString();
    }

    public static class ConfusionMatrixResult {
        public final Collection<String> categories;
        public final ArrayListMultimap<Pair<String, String>, Entry> matrixData;
        public final int instances;
        public final int positiveInstances;
        public final int negativeInstances;
        public final int truePositives;
        public final int falsePositives;
        public final int falseNegatives;
        public final double truePositivesPercent;
        public final double falseNegativesPercent;
        public final double falsePositivesPercent;
        public final Map<String, Double> precision;
        public final Map<String, Double> recall;
        public final Map<String, Double> fMeasure;
        public final double avgPrecision;
        public final double avgFMeasure;
        public final double beta;

        ConfusionMatrixResult(ConfusionMatrix m, double beta) {
            this.categories = ImmutableList.copyOf(m.getCategories());
            this.matrixData = m.calculateMatrix();
            this.instances = m.instances;
            this.positiveInstances = m.positiveInstances;
            this.negativeInstances = m.negativeInstances;
            int truePositivesCount = 0;
            int falseNegativesCount = 0;
            for (String category : m.getPositiveCategories()) {
                truePositivesCount += this.matrixData.get((Object)Pair.of(category, category)).size();
                falseNegativesCount += this.matrixData.get((Object)Pair.of(category, "0")).size();
            }
            this.truePositives = truePositivesCount;
            this.falseNegatives = falseNegativesCount;
            int falsePositivesCount = 0;
            for (String correctCategory : this.categories) {
                for (String detectedCategory : m.getPositiveCategories()) {
                    if (correctCategory.equals(detectedCategory)) continue;
                    falsePositivesCount += this.matrixData.get((Object)Pair.of(correctCategory, detectedCategory)).size();
                }
            }
            this.falsePositives = falsePositivesCount;
            if (this.positiveInstances == 0) {
                this.truePositivesPercent = 0.0;
                this.falseNegativesPercent = 0.0;
            } else {
                this.truePositivesPercent = (double)this.truePositives * 100.0 / (double)this.positiveInstances;
                this.falseNegativesPercent = (double)this.falseNegatives * 100.0 / (double)this.positiveInstances;
            }
            this.falsePositivesPercent = this.instances == 0 ? 0.0 : (double)this.falsePositives * 100.0 / (double)this.instances;
            ImmutableMap.Builder<String, Double> precisionBuilder = ImmutableMap.builder();
            ImmutableMap.Builder<String, Double> recallBuilder = ImmutableMap.builder();
            ImmutableMap.Builder<String, Double> fMeasureBuilder = ImmutableMap.builder();
            double precisionSum = 0.0;
            double fMeasureSum = 0.0;
            for (String c : this.categories) {
                double p = m.calculatePrecision(this.matrixData, c);
                double r = m.calculateRecall(this.matrixData, c);
                double f = ConfusionMatrix.calculateFMeasure(beta, p, r);
                precisionSum += p;
                fMeasureSum += f;
                precisionBuilder.put(c, p);
                recallBuilder.put(c, r);
                fMeasureBuilder.put(c, f);
            }
            this.precision = precisionBuilder.build();
            this.avgPrecision = precisionSum / (double)(this.precision.size() > 0 ? this.precision.size() : 1);
            this.recall = recallBuilder.build();
            this.fMeasure = fMeasureBuilder.build();
            this.avgFMeasure = fMeasureSum / (double)(this.fMeasure.size() > 0 ? this.fMeasure.size() : 1);
            this.beta = beta;
        }

        public String printMatrix() {
            return this.printMatrix(false);
        }

        public String printMatrix(boolean useFullLabels) {
            String headerLabel = "category\u2193 classified as\u2192";
            StringBuilder b = new StringBuilder();
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
            df.setMinimumFractionDigits(3);
            df.setMaximumFractionDigits(3);
            DecimalFormat percent = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
            percent.setMinimumFractionDigits(2);
            percent.setMaximumFractionDigits(2);
            int columnWidth = 5;
            for (Pair pair : this.matrixData.keys()) {
                columnWidth = Math.max(columnWidth, Integer.toString(this.matrixData.get((Object)pair).size()).length());
            }
            ++columnWidth;
            int categoryWidth = 0;
            for (String s : this.categories) {
                categoryWidth = Math.max(categoryWidth, s.length());
            }
            categoryWidth = Math.max(categoryWidth, "category\u2193 classified as\u2192".length());
            if (useFullLabels) {
                b.append(Strings.padStart("category\u2193 classified as\u2192", categoryWidth, ' '));
                for (String c : this.categories) {
                    b.append(Strings.padStart(c, columnWidth, ' ')).append(' ');
                }
            } else {
                b.append(Strings.padStart("category\u2193 classified as\u2192", categoryWidth + 3, ' '));
                for (int c = 0; c < this.categories.size(); ++c) {
                    b.append(Strings.padStart(ConfusionMatrix.int2str26(c) + "", columnWidth, ' ')).append(' ');
                }
            }
            b.append(" | recall\n");
            int c = 0;
            for (String correctCategory : this.categories) {
                if (useFullLabels) {
                    b.append(Strings.padEnd(correctCategory, categoryWidth, ' '));
                } else {
                    b.append(Strings.padEnd(ConfusionMatrix.int2str26(c) + ": " + correctCategory, categoryWidth + 3, ' '));
                }
                for (String detectedCategory : this.categories) {
                    int size = this.matrixData.get((Object)Pair.of(correctCategory, detectedCategory)).size();
                    String sizeString = size == 0 ? " " : size + "";
                    b.append(Strings.padStart(sizeString, columnWidth, ' ')).append(' ');
                }
                b.append(" | ").append(df.format(this.recall.get(correctCategory))).append('\n');
                ++c;
            }
            b.append('\n');
            b.append(Strings.padStart("precision:", categoryWidth, ' ')).append("   ");
            for (String detectedCategory : this.categories) {
                b.append(Strings.padStart(df.format(this.precision.get(detectedCategory)), columnWidth, ' ')).append(' ');
            }
            b.append(" \u2300 " + df.format(this.avgPrecision));
            b.append("\n");
            b.append(Strings.padStart("f-Measure (\u03b2=" + df.format(this.beta) + "):", categoryWidth, ' ')).append("   ");
            for (String detectedCategory : this.categories) {
                b.append(Strings.padStart(df.format(this.fMeasure.get(detectedCategory)), columnWidth, ' ')).append(' ');
            }
            b.append(" \u2300 " + df.format(this.avgFMeasure));
            b.append("\n\n");
            b.append("Total Sum       ").append(Strings.padStart(this.instances + "", 7, ' ')).append('\n').append("True Positives  ").append(Strings.padStart(this.truePositives + "", 7, ' ')).append("  ").append(Strings.padStart(percent.format(this.truePositivesPercent), 6, ' ')).append("%\n").append("False Negatives ").append(Strings.padStart(this.falseNegatives + "", 7, ' ')).append("  ").append(Strings.padStart(percent.format(this.falseNegativesPercent), 6, ' ')).append("%\n").append("False Positives ").append(Strings.padStart(this.falsePositives + "", 7, ' ')).append("  ").append(Strings.padStart(percent.format(this.falsePositivesPercent), 6, ' ')).append("%\n");
            return b.toString();
        }
    }

    public static class Entry {
        final String actualClass;
        final String detectedClass;
        final String filename;
        final double confidence;

        public Entry(String actualClass, String detectedClass, String filename, double confidence) {
            this.actualClass = actualClass;
            this.detectedClass = detectedClass;
            this.filename = filename;
            this.confidence = confidence;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("actual", this.actualClass).add("detected", this.detectedClass).addValue(String.format("% 4.3d", this.confidence)).addValue(this.filename).toString();
        }
    }
}

