/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.io;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import net.doo.datamining.io.Arff;
import net.doo.datamining.io.ArffAttribute;

public class ArffWriter {
    final String name;
    final ImmutableList<ArffAttribute<?>> attrs;

    public ArffWriter(String name, ArffAttribute<?> ... attrs) {
        this.attrs = ImmutableList.copyOf(attrs);
        this.name = name;
    }

    public void writeHeader(Writer out) throws IOException {
        out.write("@relation");
        out.write(32);
        Arff.writeEscapedString(out, this.name);
        out.write(10);
        out.write(10);
        for (ArffAttribute arffAttribute : this.attrs) {
            arffAttribute.writeHeader(out);
        }
        out.write(10);
        out.write("@data");
        out.write(10);
    }

    public void writeEntry(Writer out, Map<String, ?> entry) throws IOException {
        Iterator iter = this.attrs.iterator();
        while (iter.hasNext()) {
            ArffAttribute attr = (ArffAttribute)iter.next();
            attr.writeValue(out, entry.get(attr.name));
            if (iter.hasNext()) {
                out.write(44);
                continue;
            }
            out.write(10);
        }
    }
}

