/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.natalie;

import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import net.doo.datamining.AggregatedClassificationResults;
import net.doo.datamining.ClassificationResults;
import net.doo.datamining.io.BinaryChunk;
import net.doo.datamining.io.ClassifyingParams;
import net.doo.datamining.io.IO;
import net.doo.datamining.io.InfoChunkData;
import net.doo.datamining.kmeans.ResultWriter;
import net.doo.datamining.natalie.BinaryDmnbClassifier;
import net.doo.datamining.natalie.NatalieConfiguration;
import net.doo.datamining.natalie.NatalieLearningResult;
import net.doo.datamining.preprocessing.Dictionary;
import net.doo.datamining.preprocessing.WordVector;
import net.doo.datamining.util.Pair;
import net.doo.datamining.util.Tuple;
import org.apache.log4j.Logger;

public class NatalieClassifier {
    private static final Logger log = Logger.getLogger(NatalieClassifier.class);
    @Parameter(names={"-resultFolder"}, description="Folder for the classification results like html file, csv, arff. If given, the input is expected to contain the correct category in the path, i.e. each file must be of the form: [category]/[optional subcategory]/[file]")
    private String resultFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<NatalieConfiguration, NatalieLearningResult> readBinary(File binFile) throws IOException {
        BinaryChunk chunk;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(binFile));
        try {
            chunk = IO.readBinaryChunk(in, "doo\u001a");
        }
        finally {
            ((InputStream)in).close();
        }
        InfoChunkData infoChunkData = new InfoChunkData().fromChunk(chunk).assertValidity(7, 2, "natalie ");
        log.info("'" + binFile + "' contains document classification data with " + "info " + infoChunkData + ".");
        NatalieConfiguration configuration = new NatalieConfiguration().fromChunk(chunk);
        Dictionary dictionary = new Dictionary().fromChunk(chunk);
        BinaryChunk cs = chunk.readChunk("csnt");
        int classifiersCount = cs.readI32();
        ImmutableSortedMap.Builder classifiers = ImmutableSortedMap.naturalOrder();
        for (int n = 0; n < classifiersCount; ++n) {
            BinaryDmnbClassifier classifier = BinaryDmnbClassifier.fromChunk(cs, configuration.natalie.getLaplaceDefault());
            classifiers.put(classifier.categoryKey, classifier);
        }
        return Tuple.of(configuration, new NatalieLearningResult(dictionary, (ImmutableSortedMap<Pair<String, String>, BinaryDmnbClassifier>)classifiers.build()));
    }

    public static void outputClassification(AggregatedClassificationResults result) throws IOException {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.GERMAN);
        df.setMinimumFractionDigits(6);
        df.setMaximumFractionDigits(6);
        log.info("Highest ranking category: " + result.bestResult + " " + "minConfidence = " + df.format(result.minConfidence) + ", " + "confidence: " + df.format(result.confidence));
        log.info("Winning category: " + result.finalResult);
        log.trace("Raw scores:");
        for (ClassificationResults.ClassificationResult r : result.rawScores) {
            log.trace((String)r.categoryKey.fst + "_" + (String)r.categoryKey.snd + " " + df.format(r.score));
        }
    }

    public static void main(String[] args) throws Exception {
        ClassifyingParams params = new ClassifyingParams();
        NatalieClassifier classifierParams = new NatalieClassifier();
        IO.performJCommanderInitialization(args, Arrays.asList(params, classifierParams));
        Tuple<NatalieConfiguration, NatalieLearningResult> tuple = NatalieClassifier.readBinary(params.getBinaryFile());
        NatalieConfiguration c = (NatalieConfiguration)tuple.fst;
        NatalieLearningResult l = (NatalieLearningResult)tuple.snd;
        log.info(c);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (WordVector wv : c.preprocessing.getClassificationData(params.getFilesToClassify(), l.dictionary)) {
            AggregatedClassificationResults result = c.natalie.classify(l, wv);
            if (classifierParams.resultFolder != null) {
                resultBuilder.add(result);
                continue;
            }
            log.info("# " + wv.originalFilename);
            NatalieClassifier.outputClassification(result);
        }
        ResultWriter writer = new ResultWriter(resultBuilder.build(), c.toString(), 0.25);
        writer.writeStratifiedResult(new File(classifierParams.resultFolder), "natalie");
    }
}

