/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.preprocessing;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import net.doo.datamining.util.Pair;

public class WordVector {
    public final int[] indices;
    public final double[] values;
    public final String originalFilename;
    public final int originalContentLength;
    public final Pair<String, String> categoryKey;

    public WordVector(Pair<String, String> categoryKey, String originalFilename, int originalContentLength, SortedMap<Integer, Double> v) {
        this.indices = new int[v.size()];
        this.values = new double[v.size()];
        int n = 0;
        for (Map.Entry<Integer, Double> entry : v.entrySet()) {
            this.indices[n] = entry.getKey();
            this.values[n] = entry.getValue();
            ++n;
        }
        this.originalFilename = originalFilename;
        this.originalContentLength = originalContentLength;
        this.categoryKey = categoryKey;
    }

    public WordVector(Pair<String, String> categoryKey, String originalFilename, int originalContentLength, int[] indices, double[] values) {
        this.categoryKey = categoryKey;
        this.originalFilename = originalFilename;
        this.originalContentLength = originalContentLength;
        this.indices = indices;
        this.values = values;
    }

    public WordVector normalize() {
        double l = this.length();
        double[] newValues = new double[this.values.length];
        for (int n = 0; n < this.indices.length; ++n) {
            newValues[n] = this.values[n] / l;
        }
        return new WordVector(this.categoryKey, this.originalFilename, this.originalContentLength, Arrays.copyOf(this.indices, this.indices.length), newValues);
    }

    public double length() {
        double sum = 0.0;
        for (double d : this.values) {
            sum += d * d;
        }
        return Math.sqrt(sum);
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.originalFilename).addValue(this.categoryKey).add("original length", this.originalContentLength).toString();
    }
}

