/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HashSetInt
implements Iterable<Integer>,
Serializable {
    Entry[] table;
    int size;
    int threshold;
    final float loadFactor;
    int modCount;

    public HashSetInt(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public HashSetInt(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashSetInt() {
        this(16, 0.75f);
    }

    public HashSetInt(String s) {
        this(s.length() * 2);
        for (int n = 0; n < s.length(); ++n) {
            this.add(s.charAt(n));
        }
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public boolean contains(int value) {
        int hash = HashSetInt.hash(value);
        Entry e = this.table[HashSetInt.indexFor(hash, this.table.length)];
        while (e != null) {
            if (e.value == value) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean add(int value) {
        int hash = HashSetInt.hash(value);
        int i = HashSetInt.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            if (e.value == value) {
                return true;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, value, i);
        return false;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HashSetInt.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    final Entry removeEntry(int value) {
        Entry prev;
        int hash = HashSetInt.hash(value);
        int i = HashSetInt.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.value == value) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.table, 0, this.table.length, null);
        this.size = 0;
    }

    void addEntry(int hash, int value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ValueIterator();
    }

    public Collection<Integer> values() {
        return new Values();
    }

    public String valuesAsString() {
        StringBuilder b = new StringBuilder(this.size);
        for (int v : this.values()) {
            b.append((char)v);
        }
        return b.toString();
    }

    private final class Values
    extends AbstractCollection<Integer> {
        private Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return HashSetInt.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return this.contains(o);
        }

        @Override
        public void clear() {
            HashSetInt.this.clear();
        }
    }

    private final class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator<Integer> {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = HashSetInt.this.modCount;
            if (HashSetInt.this.size > 0) {
                Entry[] t = HashSetInt.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (HashSetInt.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = HashSetInt.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashSetInt.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            int value = this.current.value;
            this.current = null;
            HashSetInt.this.removeEntry(value);
            this.expectedModCount = HashSetInt.this.modCount;
        }
    }

    static class Entry
    implements Serializable {
        int value;
        Entry next;
        final int hash;

        Entry(int h, int v, Entry n) {
            this.value = v;
            this.next = n;
            this.hash = h;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return e.value == this.value;
        }

        public final int hashCode() {
            return this.value;
        }

        public final String toString() {
            return Integer.toString(this.value);
        }
    }
}

