package net.doo.snap.lib.snap.camera;

import android.content.Context;

import com.commonsware.cwac.camera.DeviceProfile;
import com.google.inject.Inject;
import com.google.inject.Provider;

import net.doo.snap.lib.BuildConfig;
import net.doo.snap.lib.snap.camera.debug.DebugCameraHost;

import roboguice.RoboGuice;

/**
 * Provides implementation of {@link net.doo.snap.lib.snap.camera.SnapCameraHost}
 */
public class HostProvider implements Provider<SnapCameraHost> {

    private static boolean USE_DEBUG_HOST = false;

    @Inject
    private Context context;

    @Override
    public SnapCameraHost get() {
        if (BuildConfig.DEBUG && USE_DEBUG_HOST) {
            DebugCameraHost host = new DebugCameraHost(context);
            RoboGuice.getInjector(context).injectMembersWithoutViews(host);
            return host;
        } else if (DeviceProfile.getInstance(context).isCustomRom()) {
            return new CustomROMCameraHost(context);
        } else {
            return new SnapCameraHost(context);
        }
    }

}
