/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.util;

import android.animation.Animator;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewTreeObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewUtils {
    public static final float ALPHA_DEFAULT = 1.0f;
    public static final float ALPHA_TRANSPARENT = 0.0f;
    public static final float SCALE_DEFAULT = 1.0f;
    public static final float TRANSLATION_DEFAULT = 0.0f;
    private static final int TRANSLATION_X = 0;
    private static final int TRANSLATION_Y = 1;
    private static final int SCALE_X = 2;
    private static final int SCALE_Y = 3;
    private static final int ROTATION = 4;
    private static final int ALPHA = 5;

    public static void saveViewTransformation(View view) {
        float[] values = new float[]{view.getTranslationX(), view.getTranslationY(), view.getScaleX(), view.getScaleY(), view.getRotation(), view.getAlpha()};
        view.setTag((Object)values);
    }

    public static void restoreViewTransformation(View view) throws IllegalStateException {
        Object tag = view.getTag();
        if (tag == null) {
            return;
        }
        if (!(tag instanceof float[])) {
            throw new IllegalStateException();
        }
        float[] values = (float[])tag;
        view.setTranslationX(values[0]);
        view.setTranslationY(values[1]);
        view.setScaleX(values[2]);
        view.setScaleY(values[3]);
        view.setRotation(values[4]);
        view.setAlpha(values[5]);
    }

    public static void postOnPreDraw(final View view, final Runnable runnable) {
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onPreDraw() {
                try {
                    runnable.run();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
            }
        });
    }

    public static Rect getViewBounds(View view) {
        Rect bounds = new Rect();
        view.getGlobalVisibleRect(bounds);
        return bounds;
    }

    public static float fitBitmapToView(@Nullable Bitmap bitmap, @NotNull View view, float rotation) {
        if (bitmap == null) {
            return 1.0f;
        }
        RectF imageBounds = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        return ViewUtils.fitRectToView(view, rotation, imageBounds);
    }

    public static float fitDrawableToView(@Nullable Drawable drawable2, @NotNull View view, float rotation) {
        if (drawable2 == null) {
            return 1.0f;
        }
        RectF drawableBounds = new RectF(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
        return ViewUtils.fitRectToView(view, rotation, drawableBounds);
    }

    public static float fitRectToView(View view, float rotation, RectF imageBounds) {
        RectF viewBounds = new RectF(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        Matrix matrix = new Matrix();
        matrix.setRotate(rotation, imageBounds.centerX(), imageBounds.centerY());
        matrix.mapRect(imageBounds);
        matrix.reset();
        matrix.setRectToRect(imageBounds, viewBounds, Matrix.ScaleToFit.FILL);
        float[] m = new float[9];
        matrix.getValues(m);
        return Math.min(m[0], m[4]);
    }

    public static class HardwareLayerAnimationListener
    extends DefaultAnimationListener {
        private final View view;
        private final int layerType;

        public HardwareLayerAnimationListener(View view) {
            this.view = view;
            this.layerType = view.getLayerType();
        }

        public void onAnimationStart(Animator animator2) {
            this.view.setLayerType(2, null);
        }

        public void onAnimationFinished(Animator animator2) {
            this.view.setLayerType(this.layerType, null);
        }
    }

    public static class DefaultAnimationListener
    implements Animator.AnimatorListener {
        private boolean ended = false;

        public void onAnimationStart(Animator animator2) {
            this.ended = false;
        }

        public final void onAnimationEnd(Animator animator2) {
            if (this.ended) {
                return;
            }
            this.onAnimationFinished(animator2);
            this.ended = true;
        }

        public void onAnimationFinished(Animator animator2) {
        }

        public void onAnimationCancel(Animator animator2) {
        }

        public void onAnimationRepeat(Animator animator2) {
        }
    }
}

