/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.genuineness;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.widget.Toast;
import com.google.android.vending.licensing.LicenseChecker;
import com.google.android.vending.licensing.LicenseCheckerCallback;
import com.google.inject.Inject;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.persistence.DocumentDraft;
import net.doo.snap.lib.snap.event.CheckGenuinenessEvent;
import net.doo.snap.lib.snap.event.SaveDocumentEvent;
import net.doo.snap.lib.util.GooglePlayPageOpener;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.event.OnDestroyEvent;
import roboguice.event.EventManager;
import roboguice.event.Observes;

public class GenuinenessChecker {
    private static final int DEBUG_SIGNATURE = 1105598010;
    private static final int RELEASE_SIGNATURE = 2027059470;
    private static final String BASE64_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAu82nw1cLa7TrVGRF00wnHci9NqHuVAnH5EFeyoUKhLBX9duv6guVRktGx5ad7K35SPy8ZksaIvZnL6j2IbUtjweRPP+tXewONGhV4j+7wROQ2G4k2zbBVo7bKXzgKEfbpbKTbH4iub0xdBxsvW6X4OwbZ1zDrC+b4pHlddJpP167XouU7DCuaErLnnchf/ZA/2yha9s4boqIYty6e9hrOwjDf13Co05k+FWHMI5hQBCwL/4oljB/GXHs0mDvUsLa9vos3jjNxGht3aheZBlgLRyIht8u/hN1ZWs4RyUqI9Mmok3CSajbcnQj8PLzuY274iqklg4shgAzoVTOv3it4wIDAQAB";
    private static final byte[] SALT = new byte[]{32, 113, -28, 90, -39, -12, -127, -112, 120, -80, 90, 100, -102, 44, 7, -91, -122, -68, -94, 103};
    private static final int ERROR_DEBUG_SIGNATURE = 2146616982;
    private static final int ERROR_RELEASE_SIGNATURE = 349857392;
    private static final int ERROR_DEBUGGABLE = 645892742;
    private static final int ERROR_LICENSE = -234508713;
    private static final int ERROR_FAKE_CALLBACK = -930724074;
    private static final int GOOD_LICENSE = -309808353;
    private static final int ERROR_RETRY_ALLOW = 893475983;
    private static final int ERROR_RETRY_DENY = 1487355394;
    private static final String STORE_PACKAGE = "com.android.vending";
    private Genuineness genuineness = Genuineness.NO;
    private LicenseCheckerCallback licenseCheckerCallback;
    private LicenseChecker checker;
    private boolean licenseCheckStarted = false;
    @Inject
    private Context context;
    @Inject
    private EventManager eventManager;
    @Inject
    private GooglePlayPageOpener googlePlayPageOpener;

    @Inject
    public GenuinenessChecker(Context context) {
        this.context = context;
        int signature = 0;
        try {
            Signature[] signatures = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
            signature = signatures[0].hashCode();
        }
        catch (PackageManager.NameNotFoundException e) {
            DebugLog.logException(e);
        }
        if (1105598010 == signature) {
            this.genuineness = Genuineness.UNKNOWN;
            return;
        }
        this.trackLicense(2146616982);
        this.genuineness = Genuineness.NO;
    }

    public Genuineness getAppGenuineness() {
        return this.genuineness;
    }

    private void onDestroy(@Observes OnDestroyEvent event) {
        if (this.checker != null) {
            this.checker.onDestroy();
        }
    }

    private void trackLicense(int reason) {
        switch (reason) {
            case -309808353: {
                EasyTrackerWrapper.sendEvent("license", "genuine", "license_check", 0L);
                break;
            }
            case -234508713: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "license_check", 0L);
                break;
            }
            case 2146616982: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "debug_signature", 0L);
                break;
            }
            case 349857392: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "release_signature", 0L);
                break;
            }
            case 645892742: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "debuggable", 0L);
                break;
            }
            case -930724074: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "fake_callback", 0L);
                break;
            }
            case 893475983: {
                EasyTrackerWrapper.sendEvent("license", "genuine", "retry_allow", 0L);
                break;
            }
            case 1487355394: {
                EasyTrackerWrapper.sendEvent("license", "not_genuine", "retry_deny", 0L);
            }
        }
    }

    private void checkDocument(@Observes CheckGenuinenessEvent event) {
        if (this.checker != null && !this.licenseCheckStarted) {
            this.licenseCheckStarted = true;
            this.checker.checkAccess(this.licenseCheckerCallback);
        }
        DocumentDraft documentDraft = event.getDraft();
        if (this.getAppGenuineness().equals((Object)Genuineness.NO)) {
            this.redirectToGooglePlay();
            EasyTrackerWrapper.sendEvent("license", "unauthorized_use", "save_document", 0L);
            return;
        }
        this.eventManager.fire((Object)new SaveDocumentEvent(documentDraft));
    }

    private void redirectToGooglePlay() {
        Toast.makeText((Context)this.context, (int)2131099686, (int)1).show();
        this.googlePlayPageOpener.openGooglePlayPage();
    }

    private class GenuinenessCheckerCallback
    implements LicenseCheckerCallback {
        private GenuinenessCheckerCallback() {
        }

        public void allow(int policyReason) {
            if (256 == policyReason) {
                if (GenuinenessChecker.this.licenseCheckStarted) {
                    GenuinenessChecker.this.licenseCheckStarted = false;
                    GenuinenessChecker.this.trackLicense(-309808353);
                    GenuinenessChecker.this.genuineness = Genuineness.YES;
                } else {
                    GenuinenessChecker.this.trackLicense(-930724074);
                    GenuinenessChecker.this.genuineness = Genuineness.NO;
                }
            } else if (291 == policyReason) {
                GenuinenessChecker.this.trackLicense(893475983);
                GenuinenessChecker.this.genuineness = Genuineness.UNKNOWN;
            }
        }

        public void dontAllow(int policyReason) {
            if (561 == policyReason) {
                GenuinenessChecker.this.trackLicense(-234508713);
                GenuinenessChecker.this.genuineness = Genuineness.NO;
            } else if (291 == policyReason) {
                GenuinenessChecker.this.trackLicense(1487355394);
                GenuinenessChecker.this.genuineness = Genuineness.UNKNOWN;
            }
        }

        public void applicationError(int errorCode) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Genuineness {
        YES,
        NO,
        UNKNOWN;

    }
}

