/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.util;

import android.animation.Animator;
import android.view.MotionEvent;
import android.view.View;
import net.doo.snap.lib.ui.util.ViewUtils;

public abstract class SwipeDownTouchListener
implements View.OnTouchListener {
    private static final float SWIPE_DOWN_FACTOR = 0.3f;
    private final View view;
    private float historicalY;
    private float diff;

    protected SwipeDownTouchListener(View view) {
        this.view = view;
    }

    public boolean onTouch(View v, MotionEvent event) {
        float y = event.getY() + this.view.getTranslationY();
        switch (event.getAction()) {
            case 0: {
                this.historicalY = y;
                this.diff = 0.0f;
                break;
            }
            case 2: {
                this.diff = y - this.historicalY;
                if (this.diff < 0.0f) {
                    this.diff = 0.0f;
                }
                if (this.diff > (float)this.view.getHeight()) {
                    this.onSwipeDownDetected();
                    return false;
                }
                this.view.setTranslationY(this.diff);
                this.view.setAlpha(((float)this.view.getHeight() - this.diff) / (float)this.view.getHeight());
                break;
            }
            case 1: 
            case 3: {
                if (this.diff > (float)this.view.getHeight() * 0.3f) {
                    this.onSwipeDownDetected();
                    break;
                }
                this.view.animate().alpha(1.0f).translationY(0.0f).setListener((Animator.AnimatorListener)new ViewUtils.HardwareLayerAnimationListener(this.view));
            }
        }
        return true;
    }

    protected abstract void onSwipeDownDetected();
}

