/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import net.doo.snap.lib.R;
import net.doo.snap.lib.ui.widget.text.TypefaceProvider;
import net.doo.snap.lib.ui.widget.text.processor.BulletProcessStrategy;
import net.doo.snap.lib.ui.widget.text.processor.StressedProcessStrategy;
import net.doo.snap.lib.ui.widget.text.processor.TextProcessor;

public class CustomTypefaceTextView
extends TextView {
    private TypefaceProvider typefaceProvider;
    private TextProcessor textProcessor = new TextProcessor();

    public CustomTypefaceTextView(Context context) {
        super(context);
    }

    public CustomTypefaceTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public CustomTypefaceTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initView(Context context, AttributeSet attrs) {
        Drawable bullet;
        this.typefaceProvider = new TypefaceProvider();
        boolean updateText = false;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomTypefaceTextView);
        try {
            String typefaceName = a.getString(0);
            this.initMainTypeface(context, typefaceName);
            String stressTypefaceName = a.getString(1);
            updateText |= this.initStressTypeface(context, stressTypefaceName);
            bullet = a.getDrawable(2);
        }
        finally {
            a.recycle();
        }
        if (updateText |= this.initBullet(bullet)) {
            this.setText(this.getText());
        }
    }

    private void initMainTypeface(Context context, String typefaceName) {
        if (typefaceName == null || this.isInEditMode()) {
            return;
        }
        this.setTypeface(this.typefaceProvider.getTypeface(context, typefaceName));
    }

    private boolean initStressTypeface(Context context, String typefaceName) {
        if (typefaceName == null || this.isInEditMode()) {
            return false;
        }
        this.textProcessor.addStrategy(new StressedProcessStrategy(this.typefaceProvider.getTypeface(context, typefaceName)));
        return true;
    }

    private boolean initBullet(Drawable bullet) {
        if (bullet == null || this.isInEditMode()) {
            return false;
        }
        this.textProcessor.addStrategy(new BulletProcessStrategy(bullet));
        return true;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.textProcessor != null) {
            type = TextView.BufferType.SPANNABLE;
            text = this.textProcessor.processText(((Object)text).toString());
        }
        super.setText(text, type);
    }
}

