package net.doo.snap.lib.detector;

import android.graphics.PointF;

import java.util.List;

/**
 * Used to notify detection results to display
 *
 * @see net.doo.snap.lib.detector.ContourDetector
 * @see net.doo.snap.lib.snap.camera.DetectionTask
 */
public interface CameraDetectorListener {
    /**
     * Detection was correctly done, polygon can be displayed
     * @param polygon to display
     */
    void onDetectionOK(List<PointF> polygon);

    /**
     * There was a problem during detection, results might be imprecise or can be improved with user interaction
     * @param result {@link net.doo.snap.lib.detector.DetectionResult}
     * @param polygon detected polygon that can be displayed together with the error message or advice
     */
    void onDetectionWithError(DetectionResult result, List<PointF> polygon);

    /**
     * Detection failed, no polygon was detected
     * @param result {@link net.doo.snap.lib.detector.DetectionResult} used to show error message if needed
     */
    void onDetectionFailed(DetectionResult result);
}
