package net.doo.snap.lib.ui.events;

import android.graphics.Bitmap;
import android.view.View;

import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.snap.ImagePreviewFragment;

/**
 * Fired when UI representation of {@link net.doo.snap.lib.persistence.Page} was
 * long pressed
 */
public class OnPageLongPressedEvent {

    private final float x;
    private final float y;
    private final View view;
    private final Page draggedPage;
    private final ImagePreviewFragment draggedFragment;
    private final Bitmap preservedBitmap;

    public OnPageLongPressedEvent(float x,
                                  float y,
                                  View view,
                                  Page draggedPage,
                                  ImagePreviewFragment draggedFragment,
                                  Bitmap preservedBitmap) {
        this.x = x;
        this.y = y;
        this.view = view;
        this.draggedPage = draggedPage;
        this.draggedFragment = draggedFragment;
        this.preservedBitmap = preservedBitmap;
    }

    /**
     * @return position at which drag were started
     */
    public float getX() {
        return x;
    }

    /**
     * @return position at which drag were started
     */
    public float getY() {
        return y;
    }

    /**
     * @return {@link android.view.View} that triggered drag event
     */
    public View getView() {
        return view;
    }

    /**
     * @return information, which should be associated with drag event
     */
    public Page getDraggedPage() {
        return draggedPage;
    }

    /**
     * @return {@link net.doo.snap.lib.snap.ImagePreviewFragment} which initiated drag
     */
    public ImagePreviewFragment getDraggedFragment() {
        return draggedFragment;
    }

    /**
     * @return preserved {@link android.graphics.Bitmap} which might be used to display {@link net.doo.snap.lib.persistence.Page}
     * right after drop-in event, which lets to avoid unnecessary image loading.
     */
    public Bitmap getPreservedBitmap() {
        return preservedBitmap;
    }
}
