/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.doo.snap.lib.persistence.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentDraft
implements Parcelable {
    private final ArrayList<Page> pages;
    private String documentName;
    public static final Parcelable.Creator<DocumentDraft> CREATOR = new Parcelable.Creator<DocumentDraft>(){

        public DocumentDraft createFromParcel(Parcel in) {
            return new DocumentDraft(in);
        }

        public DocumentDraft[] newArray(int size) {
            return new DocumentDraft[size];
        }
    };

    public DocumentDraft(Page ... pages) {
        this.pages = new ArrayList();
        Collections.addAll(this.pages, pages);
    }

    public void addPage(Page page) {
        this.pages.add(page);
        if (this.pages.size() == 1) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd H.mm.ss", Locale.US);
            String dateTime = format.format(new Date());
            this.setDocumentName("Scan " + dateTime);
        }
    }

    public void addPage(int position, Page page) {
        this.pages.add(position, page);
    }

    public void replacePage(int position, Page page) throws IndexOutOfBoundsException {
        this.pages.remove(position);
        if (position == this.pages.size()) {
            this.pages.add(page);
        } else {
            this.pages.add(position, page);
        }
    }

    public Page getPage(int position) throws IndexOutOfBoundsException {
        return this.pages.get(position);
    }

    public void deletePage(int position) throws IndexOutOfBoundsException {
        this.pages.remove(position);
    }

    public void deletePage(Page page) {
        this.pages.remove(page);
    }

    public int getPosition(Page page) {
        return this.pages.indexOf(page);
    }

    public int size() {
        return this.pages.size();
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public List<Page> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    protected DocumentDraft(Parcel in) {
        if (in.readByte() == 1) {
            this.pages = new ArrayList();
            in.readList(this.pages, Page.class.getClassLoader());
        } else {
            this.pages = null;
        }
        this.documentName = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.pages == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.pages);
        }
        dest.writeString(this.documentName);
    }
}

