/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.util.List;
import net.doo.snap.lib.detector.CameraDetectorListener;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.util.log.DebugLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectionTask
implements Runnable {
    private ContourDetector detector;
    private final byte[] image;
    private final int previewWidth;
    private final int previewHeight;
    private final CameraDetectorListener listener;

    public DetectionTask(ContourDetector detector, byte[] image, int previewWidth, int previewHeight, CameraDetectorListener listener) {
        this.detector = detector;
        this.image = image;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.listener = listener;
    }

    @Override
    public void run() {
        DetectionResult detectionResult = this.detector.detect(this.image, this.previewWidth, this.previewHeight);
        List<PointF> polygon = this.detector.getPolygonF();
        DebugLog.d("CAMERA_PREVIEW", detectionResult.name());
        DebugLog.d("CAMERA_PREVIEW", TextUtils.join((CharSequence)";", polygon));
        this.notifyCameraDetectorListener(detectionResult, polygon);
    }

    private void notifyCameraDetectorListener(final DetectionResult detectionResult, final List<PointF> polygon) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            public void run() {
                switch (detectionResult) {
                    case OK: {
                        DetectionTask.this.listener.onDetectionOK(polygon);
                        return;
                    }
                    case OK_BUT_BAD_ANGLES: 
                    case OK_BUT_BAD_ASPECT_RATIO: 
                    case OK_BUT_TOO_SMALL: {
                        DetectionTask.this.listener.onDetectionWithError(detectionResult, polygon);
                        return;
                    }
                    case ERROR_NOTHING_DETECTED: 
                    case ERROR_TOO_NOISY: 
                    case ERROR_TOO_DARK: {
                        DetectionTask.this.listener.onDetectionFailed(detectionResult);
                        return;
                    }
                }
            }
        });
    }
}

