/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.util;

import android.content.Context;
import android.view.OrientationEventListener;
import com.google.inject.Inject;
import net.doo.snap.lib.snap.util.ScreenRotationChangedEvent;
import roboguice.event.EventManager;

public class OrientationHandler
extends OrientationEventListener {
    private static final int[] ROTATION_DEGREES = new int[]{-180, -90, 0, 90};
    private static final int UPDATE_RATE_US = 200000;
    @Inject
    private EventManager eventManager;
    private int currentRotation = 0;

    @Inject
    public OrientationHandler(Context context) {
        super(context, 200000);
    }

    public void onOrientationChanged(int rotation) {
        int newRotation;
        if (!this.canDetectOrientation() || rotation < 0) {
            return;
        }
        if (rotation > 180) {
            rotation -= 360;
        }
        if ((newRotation = this.getClosestRotationDegree(rotation)) != this.currentRotation) {
            this.eventManager.fire((Object)new ScreenRotationChangedEvent(newRotation));
            this.currentRotation = newRotation;
        }
    }

    private int getClosestRotationDegree(int rotation) {
        for (int value : ROTATION_DEGREES) {
            int diff = Math.abs(rotation - value);
            if (diff >= 45) continue;
            return value;
        }
        return this.currentRotation;
    }
}

