/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;

public class AlignBlockImageView
extends ImageView {
    private Drawable block;
    private Drawable background;
    private float historicalX;
    private float historicalY;
    private Rect blockOriginalBounds = new Rect();
    private Rect blockBounds = new Rect();
    private Rect viewBounds = new Rect();
    private Rect backgroundPadding = new Rect();
    private Matrix blockMatrix = new Matrix();
    private float blockScale = 1.0f;
    private Rect tempRect = new Rect();
    private RectF tempRectF = new RectF();
    private Runnable onSizeChangedRunnable;

    public AlignBlockImageView(Context context) {
        super(context);
    }

    public AlignBlockImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AlignBlockImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setBlock(Drawable drawable2) {
        this.block = drawable2;
        if (this.block == null) {
            this.invalidate();
            return;
        }
        this.onSizeChangedRunnable = new Runnable(){

            public void run() {
                int left = (AlignBlockImageView.this.getWidth() - AlignBlockImageView.this.block.getIntrinsicWidth()) / 2;
                int top = (AlignBlockImageView.this.getHeight() - AlignBlockImageView.this.block.getIntrinsicHeight()) / 2;
                AlignBlockImageView.this.alignBlock(left, top, 1.0f);
            }
        };
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.onSizeChangedRunnable.run();
            this.onSizeChangedRunnable = null;
        }
    }

    public void setBlock(Drawable drawable2, final PointF origin, final float scale) {
        this.block = drawable2;
        if (this.block == null) {
            this.invalidate();
            return;
        }
        this.onSizeChangedRunnable = new Runnable(){

            public void run() {
                AlignBlockImageView.this.alignBlock((int)(origin.x * (float)AlignBlockImageView.this.getWidth()), (int)(origin.y * (float)AlignBlockImageView.this.getHeight()), scale);
            }
        };
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.onSizeChangedRunnable.run();
            this.onSizeChangedRunnable = null;
        }
    }

    private void alignBlock(int left, int top, float scale) {
        if (this.block != null) {
            this.blockOriginalBounds.set(left, top, left + this.block.getIntrinsicWidth(), top + this.block.getIntrinsicHeight());
            this.blockBounds.set(this.blockOriginalBounds);
            this.block.setBounds(this.blockBounds);
            this.setBlockScale(scale);
            this.alignBackground();
        }
        this.invalidate();
    }

    public PointF getBlockOrigin() {
        PointF origin = new PointF(0.0f, 0.0f);
        if (this.block == null) {
            return origin;
        }
        origin.set((float)this.blockBounds.left / (float)this.getWidth(), (float)this.blockBounds.top / (float)this.getHeight());
        return origin;
    }

    public float getBlockScale() {
        return this.block != null ? this.blockScale : 1.0f;
    }

    public boolean setBlockScale(float scale) {
        if (this.viewBounds.isEmpty() || this.block == null) {
            return false;
        }
        this.blockScale = scale;
        this.applyScale(scale);
        if (!this.viewBounds.contains(this.tempRect)) {
            this.tempRect.offset((int)Math.min(0.0f, (float)(this.viewBounds.right - this.tempRect.right - 1)), (int)Math.min(0.0f, (float)(this.viewBounds.bottom - this.tempRect.bottom - 1)));
            if (!this.viewBounds.contains(this.tempRect)) {
                return false;
            }
        }
        this.blockBounds.set(this.tempRect);
        this.block.setBounds(this.blockBounds);
        this.alignBackground();
        this.invalidate();
        return true;
    }

    private void applyScale(float scale) {
        this.tempRectF.set(this.blockOriginalBounds);
        this.blockMatrix.setScale(scale, scale);
        this.blockMatrix.mapRect(this.tempRectF);
        this.tempRect.set((int)this.tempRectF.left, (int)this.tempRectF.top, (int)this.tempRectF.right, (int)this.tempRectF.bottom);
        this.tempRect.offsetTo(this.blockBounds.left, this.blockBounds.top);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.setBackground(background);
    }

    public void setBackground(Drawable background) {
        this.background = background;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.alignBackground();
        this.viewBounds.set(this.backgroundPadding.left, this.backgroundPadding.top, w - this.backgroundPadding.right, h - this.backgroundPadding.bottom);
        if (this.onSizeChangedRunnable != null) {
            this.onSizeChangedRunnable.run();
            this.onSizeChangedRunnable = null;
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.block == null) {
            return;
        }
        this.block.draw(canvas);
        if (this.background != null) {
            this.background.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.block == null) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.historicalX = event.getX();
                this.historicalY = event.getY();
                return this.blockBounds.contains((int)this.historicalX, (int)this.historicalY);
            }
            case 2: {
                int diffX = (int)(event.getX() - this.historicalX);
                int diffY = (int)(event.getY() - this.historicalY);
                this.blockBounds.offset(diffX, 0);
                if (!this.viewBounds.contains(this.blockBounds)) {
                    this.blockBounds.offset(-diffX, 0);
                }
                this.blockBounds.offset(0, diffY);
                if (!this.viewBounds.contains(this.blockBounds)) {
                    this.blockBounds.offset(0, -diffY);
                }
                this.block.setBounds(this.blockBounds);
                this.alignBackground();
                this.invalidate();
                this.historicalX = event.getX();
                this.historicalY = event.getY();
                return true;
            }
        }
        return false;
    }

    private void alignBackground() {
        if (this.background == null) {
            return;
        }
        this.background.getPadding(this.backgroundPadding);
        this.background.setBounds(this.blockBounds.left - this.backgroundPadding.left, this.blockBounds.top - this.backgroundPadding.top, this.blockBounds.right + this.backgroundPadding.right, this.blockBounds.bottom + this.backgroundPadding.bottom);
    }
}

