/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.util;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import net.doo.snap.lib.ui.util.ViewUtils;

public class UndoToast {
    public static final int DURATION_INFINITE = -1;
    public static final int DURATION_NORMAL_MS = 3000;
    private final Activity activity;
    private final ToastView toastView;
    private boolean animate = true;
    private int duration = -1;
    private OnUndoListener listener;
    private boolean shown = false;
    private boolean dismissed = false;
    private final Runnable dismissRunnable = new Runnable(){

        public void run() {
            if (UndoToast.this.toastView.getParent() != null) {
                UndoToast.this.dismissToast();
            }
        }
    };

    public UndoToast(Activity activity) {
        this.activity = activity;
        this.toastView = new ToastView((Context)activity);
    }

    public static boolean detachToast(Activity activity) throws NullPointerException {
        ToastView previous = (ToastView)activity.findViewById(2131165190);
        if (previous != null && previous.getParent() instanceof ViewGroup) {
            ((ViewGroup)previous.getParent()).removeView((View)previous);
            return true;
        }
        return false;
    }

    public UndoToast message(int resId) {
        this.ensureNotShown();
        this.toastView.message.setText(resId);
        return this;
    }

    public UndoToast message(String message) {
        this.ensureNotShown();
        this.toastView.message.setText((CharSequence)message);
        return this;
    }

    public UndoToast listener(OnUndoListener listener) {
        this.ensureNotShown();
        this.listener = listener;
        return this;
    }

    public UndoToast animate(boolean animate) {
        this.ensureNotShown();
        this.animate = animate;
        return this;
    }

    public UndoToast duration(int duration) {
        this.ensureNotShown();
        if (duration < 0) {
            duration = -1;
        }
        this.duration = duration;
        return this;
    }

    public void show() {
        this.ensureNotShown();
        boolean detached = this.detachToast();
        this.setupListener();
        this.attachToast();
        if (this.animate && !detached) {
            this.animateToastIn();
        }
        this.shown = true;
    }

    private void setupListener() {
        if (this.listener != null) {
            this.toastView.undoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (UndoToast.this.dismissed) {
                        return;
                    }
                    UndoToast.this.listener.onUndo();
                    UndoToast.this.dismissToast();
                }
            });
        }
    }

    private void attachToast() {
        ((ViewGroup)this.activity.findViewById(0x1020002)).addView((View)this.toastView);
        if (this.duration != -1) {
            this.scheduleDetachment();
        }
    }

    private boolean detachToast() {
        return UndoToast.detachToast(this.activity);
    }

    private void scheduleDetachment() {
        this.toastView.postDelayed(this.dismissRunnable, this.duration);
    }

    private void dismissToast() {
        this.dismissed = true;
        if (this.animate) {
            this.animateToastOut();
        } else {
            this.detachToast();
        }
    }

    private void animateToastIn() {
        this.toastView.setAlpha(0.0f);
        this.toastView.animate().alpha(1.0f);
    }

    private void animateToastOut() {
        this.toastView.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            public void onAnimationFinished(Animator animator2) {
                UndoToast.this.detachToast();
            }
        });
    }

    private void ensureNotShown() {
        if (this.shown) {
            throw new IllegalStateException("Toast was already shown");
        }
    }

    public static class ToastView
    extends FrameLayout {
        public final TextView message;
        public final View undoButton;

        public ToastView(Context context) {
            super(context);
            LayoutInflater.from((Context)context).inflate(2130903065, (ViewGroup)this);
            this.message = (TextView)this.findViewById(2131165246);
            this.undoButton = this.findViewById(2131165247);
            this.setId(2131165190);
        }
    }

    public static interface OnUndoListener {
        public void onUndo();
    }
}

