package net.doo.snap.lib.snap.event;

import net.doo.snap.lib.persistence.DocumentDraft;

/**
 * Sent when the {@link net.doo.snap.lib.persistence.DocumentDraft} should be saved in the final pdf documents using
 */
public class ProcessDocumentsEvent {
    private final DocumentDraft draft;
    private final boolean single;

    public ProcessDocumentsEvent(DocumentDraft draft, boolean single) {
        this.draft = draft;
        this.single = single;
    }

    /**
     * @return {@link net.doo.snap.lib.persistence.DocumentDraft} with the latest state
     */
    public DocumentDraft getDraft() {
        return draft;
    }

    /**
     * @return {@code true} if the {@link net.doo.snap.lib.persistence.DocumentDraft} should be saved as one document, {@code false} otherwise
     */
    public boolean isSingle() {
        return single;
    }
}
