/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RotationType {
    ROTATION_0(0),
    ROTATION_90(90),
    ROTATION_180(180),
    ROTATION_270(270),
    ROTATION_360(360);

    private final int degrees;
    private static final SparseArray<RotationType> degrees2Type;

    private RotationType(int degrees) {
        this.degrees = degrees;
    }

    public static RotationType rotateClockwise(RotationType type) {
        RotationType result = ROTATION_0;
        switch (type) {
            case ROTATION_360: 
            case ROTATION_0: {
                result = ROTATION_90;
                break;
            }
            case ROTATION_90: {
                result = ROTATION_180;
                break;
            }
            case ROTATION_180: {
                result = ROTATION_270;
                break;
            }
            case ROTATION_270: {
                result = ROTATION_360;
            }
        }
        return result;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public static RotationType getByDegrees(int degrees) {
        RotationType type = (RotationType)((Object)degrees2Type.get(degrees));
        if (type == null) {
            throw new IllegalStateException("no rottation type for: " + degrees);
        }
        return type;
    }

    static {
        degrees2Type = new SparseArray();
        for (RotationType type : RotationType.values()) {
            degrees2Type.put(type.degrees, (Object)type);
        }
    }
}

