/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.SeekBar;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.persistence.SignatureStoreStrategy;
import net.doo.snap.lib.sensor.SensorHelper;
import net.doo.snap.lib.sensor.ShakeListener;
import net.doo.snap.lib.snap.util.OrientationLocker;
import net.doo.snap.lib.ui.CreateSignatureActivity;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.ui.widget.AlignBlockImageView;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.BitmapUtils;
import net.doo.snap.lib.util.bitmap.PageBitmapLoader;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditSignatureActivity
extends RoboFragmentActivity
implements LoaderManager.LoaderCallbacks<Bitmap> {
    public static final String ARGUMENT_PAGE = "page";
    public static final String RESULT_SIGNATURE = "signature";
    private static final int CREATE_SIGNATURE_REQUEST_CODE = 100;
    private static final float MIN_SCALE = 0.3f;
    private static final int DEFAULT_SCALE_PROGRESS = 50;
    private static final String STATE_SIGNATURE = "state_signature";
    private static final String LOADER_PATH = "path";
    @Inject
    private OrientationLocker orientationLocker;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private SignatureStoreStrategy signatureStoreStrategy;
    @Inject
    private ActivityAnalytics activityAnalytics;
    @Inject
    private BitmapLruCache bitmapLruCache;
    @Inject
    private SensorHelper sensorHelper;
    private Page page;
    private Signature signature;
    private Bitmap signatureBitmap;
    private AlignBlockImageView imageView;
    private MenuItem addSignature;
    private MenuItem editSignature;
    private MenuItem clearSignature;
    private SeekBar sizeBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903041);
        this.page = (Page)this.getIntent().getParcelableExtra(ARGUMENT_PAGE);
        if (this.page == null) {
            throw new NullPointerException("Page can't be null");
        }
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(false);
        actionBar.setCustomView(2130903050);
        this.imageView = (AlignBlockImageView)this.findViewById(2131165193);
        this.sizeBar = (SeekBar)this.findViewById(2131165196);
        this.sizeBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){
            private int lastProgress = 50;

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!fromUser) {
                    return;
                }
                float scale = EditSignatureActivity.this.progressToScale(progress);
                if (EditSignatureActivity.this.imageView.setBlockScale(scale)) {
                    this.lastProgress = progress;
                } else {
                    seekBar.setProgress(this.lastProgress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.findViewById(2131165224).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EditSignatureActivity.this.deliverResult();
            }
        });
        if (savedInstanceState == null) {
            this.signature = this.page.getSignature();
            if (this.signature == null) {
                this.requestSignature();
            }
        } else {
            this.restoreState(savedInstanceState);
        }
        try {
            this.getSupportLoaderManager().initLoader(0, this.buildLoaderArgs(), (LoaderManager.LoaderCallbacks)this);
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
        this.sensorHelper.registerSignificantMoveListener(new ShakeListener(){

            public void onShake() {
                EditSignatureActivity.this.resetSignature();
            }
        });
    }

    private void restoreState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        this.signature = (Signature)savedInstanceState.getParcelable(STATE_SIGNATURE);
    }

    private void deliverResult() {
        Intent intent = new Intent();
        if (this.imageView.getDrawable() == null) {
            this.setResult(0, intent);
            this.finish();
            return;
        }
        if (this.signature != null) {
            this.updateSignatureParams();
            intent.putExtra(RESULT_SIGNATURE, (Parcelable)this.signature);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.signature != null) {
            this.updateSignatureParams();
        }
        outState.putParcelable(STATE_SIGNATURE, (Parcelable)this.signature);
    }

    private void updateSignatureParams() {
        this.signature.setOrigin(this.imageView.getBlockOrigin());
        this.signature.setScale(this.progressToScale(this.sizeBar.getProgress()) * ((float)this.imageView.getDrawable().getIntrinsicWidth() / (float)this.imageView.getWidth()));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131623939, menu2);
        this.addSignature = menu2.findItem(2131165252);
        this.editSignature = menu2.findItem(2131165251);
        this.clearSignature = menu2.findItem(2131165249);
        this.addSignature.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                EditSignatureActivity.this.requestSignature();
                return true;
            }
        });
        this.clearSignature.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                EditSignatureActivity.this.resetSignature();
                return true;
            }
        });
        this.editSignature.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                EditSignatureActivity.this.requestSignature();
                return true;
            }
        });
        return true;
    }

    private void resetSignature() {
        this.signature = null;
        this.updateSignature();
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        boolean signatureValid = this.isSignatureValid();
        this.addSignature.setVisible(!signatureValid);
        this.editSignature.setVisible(signatureValid);
        this.clearSignature.setVisible(signatureValid);
        return this.imageView.getDrawable() != null;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1) {
            this.signature = (Signature)data.getParcelableExtra("RESULT_SIGNATURE");
            this.signatureBitmap = null;
            try {
                Bundle args = this.buildLoaderArgs();
                this.getSupportLoaderManager().restartLoader(0, args, (LoaderManager.LoaderCallbacks)this);
            }
            catch (IOException e) {
                DebugLog.logException(e);
            }
        }
    }

    private void updateSignature() {
        boolean signatureValid = this.isSignatureValid();
        ViewUtils.postOnPreDraw((View)this.imageView, new Runnable(){

            public void run() {
                EditSignatureActivity.this.assignSignature();
            }
        });
        int signatureUiVisibility = signatureValid ? 0 : 8;
        this.findViewById(2131165192).setVisibility(signatureUiVisibility);
        this.findViewById(2131165194).setVisibility(signatureUiVisibility);
        this.findViewById(2131165195).setVisibility(signatureUiVisibility);
        this.sizeBar.setVisibility(signatureUiVisibility);
        this.invalidateOptionsMenu();
    }

    private void assignSignature() {
        boolean signatureValid = this.isSignatureValid();
        if (signatureValid) {
            BitmapDrawable drawable2 = new BitmapDrawable(this.getResources(), this.signatureBitmap);
            if (!this.isSignatureModifiedByUser()) {
                this.imageView.setBlock((Drawable)drawable2);
                this.sizeBar.setProgress(50);
                this.updateSignatureParams();
            } else {
                float scale = this.signature.getScale() * ((float)this.imageView.getWidth() / (float)this.imageView.getDrawable().getIntrinsicWidth());
                this.imageView.setBlock((Drawable)drawable2, this.signature.getOrigin(), scale);
                this.sizeBar.setProgress(this.scaleToProgress(scale));
                this.updateSignatureParams();
            }
        } else {
            this.imageView.setBlock(null);
        }
    }

    private float progressToScale(int progress) {
        return (float)progress / 50.0f * 0.7f + 0.3f;
    }

    private int scaleToProgress(float scale) {
        return (int)((scale - 0.3f) * 50.0f / 0.7f);
    }

    private boolean isSignatureValid() {
        return this.signature != null && this.imageView.getDrawable() != null && BitmapUtils.isBitmapValid(this.signatureBitmap);
    }

    private boolean isSignatureModifiedByUser() {
        return this.signature.getOrigin().x > 0.0f && this.signature.getOrigin().y > 0.0f;
    }

    public Loader<Bitmap> onCreateLoader(int id2, Bundle args) {
        String path = args.getString(LOADER_PATH);
        return new PageBitmapLoader((Context)this, path, this.bitmapLruCache, null, false);
    }

    public void onLoadFinished(Loader<Bitmap> loader, Bitmap data) {
        data = this.rotateBitmap(data);
        this.imageView.setImageBitmap(data);
        this.updateSignature();
        if (this.signature != null && this.signatureBitmap == null) {
            new LoadSignatureBitmapTask(this.signature.getImagePath()).execute(new Void[0]);
        }
    }

    private Bitmap rotateBitmap(Bitmap data) {
        if (!BitmapUtils.isBitmapValid(data)) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)this.page.getRotationType().getDegrees());
        return Bitmap.createBitmap((Bitmap)data, (int)0, (int)0, (int)data.getWidth(), (int)data.getHeight(), (Matrix)matrix, (boolean)false);
    }

    public void onLoaderReset(Loader<Bitmap> loader) {
        this.imageView.setImageDrawable(null);
    }

    private void requestSignature() {
        this.startActivityForResult(new Intent((Context)this, CreateSignatureActivity.class), 100);
    }

    private Bundle buildLoaderArgs() throws IOException {
        Bundle args = new Bundle();
        args.putString(LOADER_PATH, this.page.getFilePath(this.pageStoreStrategy, Page.ImageType.OPTIMIZED_PREVIEW));
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadSignatureBitmapTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final String path;

        private LoadSignatureBitmapTask(String path) {
            this.path = path;
        }

        protected Bitmap doInBackground(Void ... voids) {
            return BitmapFactory.decodeFile((String)this.path);
        }

        protected void onPostExecute(Bitmap bitmap) {
            EditSignatureActivity.this.signatureBitmap = bitmap;
            EditSignatureActivity.this.updateSignature();
        }
    }
}

